// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.ResourceMover.Models
{
    public partial class MoverResourceDependency : IUtf8JsonSerializable, IJsonModel<MoverResourceDependency>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<MoverResourceDependency>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<MoverResourceDependency>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MoverResourceDependency>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MoverResourceDependency)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(Id))
            {
                writer.WritePropertyName("id"u8);
                writer.WriteStringValue(Id);
            }
            if (Optional.IsDefined(ResolutionStatus))
            {
                writer.WritePropertyName("resolutionStatus"u8);
                writer.WriteStringValue(ResolutionStatus);
            }
            if (Optional.IsDefined(ResolutionType))
            {
                writer.WritePropertyName("resolutionType"u8);
                writer.WriteStringValue(ResolutionType.Value.ToString());
            }
            if (Optional.IsDefined(DependencyType))
            {
                writer.WritePropertyName("dependencyType"u8);
                writer.WriteStringValue(DependencyType.Value.ToString());
            }
            if (Optional.IsDefined(ManualResolution))
            {
                writer.WritePropertyName("manualResolution"u8);
                writer.WriteObjectValue(ManualResolution, options);
            }
            if (Optional.IsDefined(AutomaticResolution))
            {
                writer.WritePropertyName("automaticResolution"u8);
                writer.WriteObjectValue(AutomaticResolution, options);
            }
            if (Optional.IsDefined(IsDependencyOptional))
            {
                writer.WritePropertyName("isOptional"u8);
                writer.WriteStringValue(IsDependencyOptional);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        MoverResourceDependency IJsonModel<MoverResourceDependency>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MoverResourceDependency>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MoverResourceDependency)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeMoverResourceDependency(document.RootElement, options);
        }

        internal static MoverResourceDependency DeserializeMoverResourceDependency(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier id = default;
            string resolutionStatus = default;
            MoverResourceResolutionType? resolutionType = default;
            MoverDependencyType? dependencyType = default;
            ManualResolutionProperties manualResolution = default;
            AutomaticResolutionProperties automaticResolution = default;
            string isOptional = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("resolutionStatus"u8))
                {
                    resolutionStatus = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("resolutionType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    resolutionType = new MoverResourceResolutionType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("dependencyType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    dependencyType = new MoverDependencyType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("manualResolution"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    manualResolution = ManualResolutionProperties.DeserializeManualResolutionProperties(property.Value, options);
                    continue;
                }
                if (property.NameEquals("automaticResolution"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    automaticResolution = AutomaticResolutionProperties.DeserializeAutomaticResolutionProperties(property.Value, options);
                    continue;
                }
                if (property.NameEquals("isOptional"u8))
                {
                    isOptional = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new MoverResourceDependency(
                id,
                resolutionStatus,
                resolutionType,
                dependencyType,
                manualResolution,
                automaticResolution,
                isOptional,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<MoverResourceDependency>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MoverResourceDependency>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(MoverResourceDependency)} does not support writing '{options.Format}' format.");
            }
        }

        MoverResourceDependency IPersistableModel<MoverResourceDependency>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MoverResourceDependency>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeMoverResourceDependency(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(MoverResourceDependency)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<MoverResourceDependency>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
