// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ResourceMover.Models
{
    /// <summary> Operations discovery class. </summary>
    public partial class MoverOperationsDiscovery
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MoverOperationsDiscovery"/>. </summary>
        internal MoverOperationsDiscovery()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MoverOperationsDiscovery"/>. </summary>
        /// <param name="name">
        /// Gets or sets Name of the API.
        /// The name of the operation being performed on this particular object. It should
        /// match the action name that appears in RBAC / the event service.
        /// Examples of operations include:
        /// * Microsoft.Compute/virtualMachine/capture/action
        /// * Microsoft.Compute/virtualMachine/restart/action
        /// * Microsoft.Compute/virtualMachine/write
        /// * Microsoft.Compute/virtualMachine/read
        /// * Microsoft.Compute/virtualMachine/delete
        /// Each action should include, in order:
        /// (1) Resource Provider Namespace
        /// (2) Type hierarchy for which the action applies (e.g. server/databases for a SQL
        /// Azure database)
        /// (3) Read, Write, Action or Delete indicating which type applies. If it is a PUT/PATCH
        /// on a collection or named value, Write should be used.
        /// If it is a GET, Read should be used. If it is a DELETE, Delete should be used. If it
        /// is a POST, Action should be used.
        /// As a note: all resource providers would need to include the "{Resource Provider
        /// Namespace}/register/action" operation in their response.
        /// This API is used to register for their service, and should include details about the
        /// operation (e.g. a localized name for the resource provider + any special
        /// considerations like PII release).
        /// </param>
        /// <param name="isDataAction"> Indicates whether the operation is a data action. </param>
        /// <param name="display">
        /// Contains the localized display information for this particular operation / action. These
        /// value will be used by several clients for
        /// (1) custom role definitions for RBAC;
        /// (2) complex query filters for the event service; and
        /// (3) audit history / records for management operations.
        /// </param>
        /// <param name="origin">
        /// Gets or sets Origin.
        /// The intended executor of the operation; governs the display of the operation in the
        /// RBAC UX and the audit logs UX.
        /// Default value is "user,system".
        /// </param>
        /// <param name="properties"> ClientDiscovery properties. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MoverOperationsDiscovery(string name, bool? isDataAction, MoverDisplayInfo display, string origin, BinaryData properties, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            IsDataAction = isDataAction;
            Display = display;
            Origin = origin;
            Properties = properties;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary>
        /// Gets or sets Name of the API.
        /// The name of the operation being performed on this particular object. It should
        /// match the action name that appears in RBAC / the event service.
        /// Examples of operations include:
        /// * Microsoft.Compute/virtualMachine/capture/action
        /// * Microsoft.Compute/virtualMachine/restart/action
        /// * Microsoft.Compute/virtualMachine/write
        /// * Microsoft.Compute/virtualMachine/read
        /// * Microsoft.Compute/virtualMachine/delete
        /// Each action should include, in order:
        /// (1) Resource Provider Namespace
        /// (2) Type hierarchy for which the action applies (e.g. server/databases for a SQL
        /// Azure database)
        /// (3) Read, Write, Action or Delete indicating which type applies. If it is a PUT/PATCH
        /// on a collection or named value, Write should be used.
        /// If it is a GET, Read should be used. If it is a DELETE, Delete should be used. If it
        /// is a POST, Action should be used.
        /// As a note: all resource providers would need to include the "{Resource Provider
        /// Namespace}/register/action" operation in their response.
        /// This API is used to register for their service, and should include details about the
        /// operation (e.g. a localized name for the resource provider + any special
        /// considerations like PII release).
        /// </summary>
        public string Name { get; }
        /// <summary> Indicates whether the operation is a data action. </summary>
        public bool? IsDataAction { get; }
        /// <summary>
        /// Contains the localized display information for this particular operation / action. These
        /// value will be used by several clients for
        /// (1) custom role definitions for RBAC;
        /// (2) complex query filters for the event service; and
        /// (3) audit history / records for management operations.
        /// </summary>
        public MoverDisplayInfo Display { get; }
        /// <summary>
        /// Gets or sets Origin.
        /// The intended executor of the operation; governs the display of the operation in the
        /// RBAC UX and the audit logs UX.
        /// Default value is "user,system".
        /// </summary>
        public string Origin { get; }
        /// <summary>
        /// ClientDiscovery properties.
        /// <para>
        /// To assign an object to this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        public BinaryData Properties { get; }
    }
}
