// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ResourceMover.Models
{
    /// <summary> The operation error info. </summary>
    public partial class MoverOperationErrorAdditionalInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MoverOperationErrorAdditionalInfo"/>. </summary>
        internal MoverOperationErrorAdditionalInfo()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MoverOperationErrorAdditionalInfo"/>. </summary>
        /// <param name="operationErrorAdditionalInfoType"> The error type. </param>
        /// <param name="info"> The operation error info. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MoverOperationErrorAdditionalInfo(string operationErrorAdditionalInfoType, MoveErrorInfo info, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            OperationErrorAdditionalInfoType = operationErrorAdditionalInfoType;
            Info = info;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The error type. </summary>
        public string OperationErrorAdditionalInfoType { get; }
        /// <summary> The operation error info. </summary>
        internal MoveErrorInfo Info { get; }
        /// <summary> The affected move resources. </summary>
        public IReadOnlyList<AffectedMoverResourceInfo> InfoMoverResources
        {
            get => Info?.InfoMoverResources;
        }
    }
}
