// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ResourceMover.Models
{
    /// <summary> Defines the dependency type. </summary>
    public readonly partial struct MoverDependencyType : IEquatable<MoverDependencyType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MoverDependencyType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MoverDependencyType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string RequiredForPrepareValue = "RequiredForPrepare";
        private const string RequiredForMoveValue = "RequiredForMove";

        /// <summary> RequiredForPrepare. </summary>
        public static MoverDependencyType RequiredForPrepare { get; } = new MoverDependencyType(RequiredForPrepareValue);
        /// <summary> RequiredForMove. </summary>
        public static MoverDependencyType RequiredForMove { get; } = new MoverDependencyType(RequiredForMoveValue);
        /// <summary> Determines if two <see cref="MoverDependencyType"/> values are the same. </summary>
        public static bool operator ==(MoverDependencyType left, MoverDependencyType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MoverDependencyType"/> values are not the same. </summary>
        public static bool operator !=(MoverDependencyType left, MoverDependencyType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MoverDependencyType"/>. </summary>
        public static implicit operator MoverDependencyType(string value) => new MoverDependencyType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MoverDependencyType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MoverDependencyType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
