// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.ResourceMover.Models
{
    internal partial class MoveResourcePropertiesErrors : IUtf8JsonSerializable, IJsonModel<MoveResourcePropertiesErrors>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<MoveResourcePropertiesErrors>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<MoveResourcePropertiesErrors>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MoveResourcePropertiesErrors>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MoveResourcePropertiesErrors)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
        }

        MoveResourcePropertiesErrors IJsonModel<MoveResourcePropertiesErrors>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MoveResourcePropertiesErrors>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MoveResourcePropertiesErrors)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeMoveResourcePropertiesErrors(document.RootElement, options);
        }

        internal static MoveResourcePropertiesErrors DeserializeMoveResourcePropertiesErrors(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResponseError properties = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    properties = JsonSerializer.Deserialize<ResponseError>(property.Value.GetRawText());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new MoveResourcePropertiesErrors(properties, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<MoveResourcePropertiesErrors>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MoveResourcePropertiesErrors>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(MoveResourcePropertiesErrors)} does not support writing '{options.Format}' format.");
            }
        }

        MoveResourcePropertiesErrors IPersistableModel<MoveResourcePropertiesErrors>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MoveResourcePropertiesErrors>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeMoveResourcePropertiesErrors(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(MoveResourcePropertiesErrors)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<MoveResourcePropertiesErrors>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
