// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.ResourceMover.Models
{
    public partial class LoadBalancerBackendAddressPoolReferenceInfo : IUtf8JsonSerializable, IJsonModel<LoadBalancerBackendAddressPoolReferenceInfo>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<LoadBalancerBackendAddressPoolReferenceInfo>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<LoadBalancerBackendAddressPoolReferenceInfo>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<LoadBalancerBackendAddressPoolReferenceInfo>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(LoadBalancerBackendAddressPoolReferenceInfo)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
        }

        LoadBalancerBackendAddressPoolReferenceInfo IJsonModel<LoadBalancerBackendAddressPoolReferenceInfo>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<LoadBalancerBackendAddressPoolReferenceInfo>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(LoadBalancerBackendAddressPoolReferenceInfo)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeLoadBalancerBackendAddressPoolReferenceInfo(document.RootElement, options);
        }

        internal static LoadBalancerBackendAddressPoolReferenceInfo DeserializeLoadBalancerBackendAddressPoolReferenceInfo(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string name = default;
            ResourceIdentifier sourceArmResourceId = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("sourceArmResourceId"u8))
                {
                    sourceArmResourceId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new LoadBalancerBackendAddressPoolReferenceInfo(sourceArmResourceId, serializedAdditionalRawData, name);
        }

        BinaryData IPersistableModel<LoadBalancerBackendAddressPoolReferenceInfo>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<LoadBalancerBackendAddressPoolReferenceInfo>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(LoadBalancerBackendAddressPoolReferenceInfo)} does not support writing '{options.Format}' format.");
            }
        }

        LoadBalancerBackendAddressPoolReferenceInfo IPersistableModel<LoadBalancerBackendAddressPoolReferenceInfo>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<LoadBalancerBackendAddressPoolReferenceInfo>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeLoadBalancerBackendAddressPoolReferenceInfo(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(LoadBalancerBackendAddressPoolReferenceInfo)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<LoadBalancerBackendAddressPoolReferenceInfo>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
