// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.ResourceMover.Models
{
    /// <summary> The RP custom operation error info. </summary>
    public partial class AffectedMoverResourceInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AffectedMoverResourceInfo"/>. </summary>
        internal AffectedMoverResourceInfo()
        {
            MoverResources = new ChangeTrackingList<AffectedMoverResourceInfo>();
        }

        /// <summary> Initializes a new instance of <see cref="AffectedMoverResourceInfo"/>. </summary>
        /// <param name="id"> The affected move resource id. </param>
        /// <param name="sourceId"> The affected move resource source id. </param>
        /// <param name="moverResources"> The affected move resources. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AffectedMoverResourceInfo(ResourceIdentifier id, ResourceIdentifier sourceId, IReadOnlyList<AffectedMoverResourceInfo> moverResources, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Id = id;
            SourceId = sourceId;
            MoverResources = moverResources;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The affected move resource id. </summary>
        public ResourceIdentifier Id { get; }
        /// <summary> The affected move resource source id. </summary>
        public ResourceIdentifier SourceId { get; }
        /// <summary> The affected move resources. </summary>
        public IReadOnlyList<AffectedMoverResourceInfo> MoverResources { get; }
    }
}
