// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.ResourceMover
{
    internal class MoverResourceOperationSource : IOperationSource<MoverResource>
    {
        private readonly ArmClient _client;

        internal MoverResourceOperationSource(ArmClient client)
        {
            _client = client;
        }

        MoverResource IOperationSource<MoverResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = MoverResourceData.DeserializeMoverResourceData(document.RootElement);
            return new MoverResource(_client, data);
        }

        async ValueTask<MoverResource> IOperationSource<MoverResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = MoverResourceData.DeserializeMoverResourceData(document.RootElement);
            return new MoverResource(_client, data);
        }
    }
}
