// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.ResourceManager.ResourceMover.Models;

namespace Azure.ResourceManager.ResourceMover
{
    internal class MoverOperationStatusOperationSource : IOperationSource<MoverOperationStatus>
    {
        MoverOperationStatus IOperationSource<MoverOperationStatus>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            return MoverOperationStatus.DeserializeMoverOperationStatus(document.RootElement);
        }

        async ValueTask<MoverOperationStatus> IOperationSource<MoverOperationStatus>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            return MoverOperationStatus.DeserializeMoverOperationStatus(document.RootElement);
        }
    }
}
