// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Threading;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.ResourceMover.Models;

namespace Azure.ResourceManager.ResourceMover.Mocking
{
    /// <summary> A class to add extension methods to TenantResource. </summary>
    public partial class MockableResourceMoverTenantResource : ArmResource
    {
        private ClientDiagnostics _operationsDiscoveryClientDiagnostics;
        private OperationsDiscoveryRestOperations _operationsDiscoveryRestClient;

        /// <summary> Initializes a new instance of the <see cref="MockableResourceMoverTenantResource"/> class for mocking. </summary>
        protected MockableResourceMoverTenantResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableResourceMoverTenantResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableResourceMoverTenantResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        private ClientDiagnostics OperationsDiscoveryClientDiagnostics => _operationsDiscoveryClientDiagnostics ??= new ClientDiagnostics("Azure.ResourceManager.ResourceMover", ProviderConstants.DefaultProviderNamespace, Diagnostics);
        private OperationsDiscoveryRestOperations OperationsDiscoveryRestClient => _operationsDiscoveryRestClient ??= new OperationsDiscoveryRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint);

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Migrate/operations</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>OperationsDiscovery_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-08-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="MoverOperationsDiscovery"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<MoverOperationsDiscovery> GetOperationsDiscoveriesAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => OperationsDiscoveryRestClient.CreateGetRequest();
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, null, e => MoverOperationsDiscovery.DeserializeMoverOperationsDiscovery(e), OperationsDiscoveryClientDiagnostics, Pipeline, "MockableResourceMoverTenantResource.GetOperationsDiscoveries", "value", null, cancellationToken);
        }

        /// <summary>
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Migrate/operations</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>OperationsDiscovery_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-08-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="MoverOperationsDiscovery"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<MoverOperationsDiscovery> GetOperationsDiscoveries(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => OperationsDiscoveryRestClient.CreateGetRequest();
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, null, e => MoverOperationsDiscovery.DeserializeMoverOperationsDiscovery(e), OperationsDiscoveryClientDiagnostics, Pipeline, "MockableResourceMoverTenantResource.GetOperationsDiscoveries", "value", null, cancellationToken);
        }
    }
}
