// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.ResourceMover.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmResourceMoverModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="ResourceMover.MoverResourceSetData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="etag"> The etag of the resource. </param>
        /// <param name="identity"> Defines the MSI properties of the Move Collection. Current supported identity types: None, SystemAssigned, UserAssigned. </param>
        /// <param name="properties"> Defines the move collection properties. </param>
        /// <returns> A new <see cref="ResourceMover.MoverResourceSetData"/> instance for mocking. </returns>
        public static MoverResourceSetData MoverResourceSetData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ETag? etag = null, ManagedServiceIdentity identity = null, MoverResourceSetProperties properties = null)
        {
            tags ??= new Dictionary<string, string>();

            return new MoverResourceSetData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                etag,
                identity,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MoverResourceSetProperties"/>. </summary>
        /// <param name="sourceLocation"> Gets or sets the source region. </param>
        /// <param name="targetLocation"> Gets or sets the target region. </param>
        /// <param name="moveLocation"> Gets or sets the move region which indicates the region where the VM Regional to Zonal move will be conducted. </param>
        /// <param name="provisioningState"> Defines the provisioning states. </param>
        /// <param name="version"> Gets or sets the version of move collection. </param>
        /// <param name="moveType"> Defines the MoveType. </param>
        /// <param name="errorsProperties"> Defines the move collection errors. </param>
        /// <returns> A new <see cref="Models.MoverResourceSetProperties"/> instance for mocking. </returns>
        public static MoverResourceSetProperties MoverResourceSetProperties(AzureLocation? sourceLocation = null, AzureLocation? targetLocation = null, AzureLocation? moveLocation = null, MoverProvisioningState? provisioningState = null, string version = null, MoveType? moveType = null, ResponseError errorsProperties = null)
        {
            return new MoverResourceSetProperties(
                sourceLocation,
                targetLocation,
                moveLocation,
                provisioningState,
                version,
                moveType,
                errorsProperties != null ? new MoveCollectionPropertiesErrors(errorsProperties, serializedAdditionalRawData: null) : null,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MoverOperationStatus"/>. </summary>
        /// <param name="id"> Resource Id. </param>
        /// <param name="name"> Operation name. </param>
        /// <param name="status"> Status of the operation. ARM expects the terminal status to be one of Succeeded/ Failed/ Canceled. All other values imply that the operation is still running. </param>
        /// <param name="startOn"> Start time. </param>
        /// <param name="endOn"> End time. </param>
        /// <param name="error"> Error stating all error details for the operation. </param>
        /// <param name="properties"> Custom data. </param>
        /// <returns> A new <see cref="Models.MoverOperationStatus"/> instance for mocking. </returns>
        public static MoverOperationStatus MoverOperationStatus(ResourceIdentifier id = null, string name = null, string status = null, DateTimeOffset? startOn = null, DateTimeOffset? endOn = null, MoverOperationStatusError error = null, BinaryData properties = null)
        {
            return new MoverOperationStatus(
                id,
                name,
                status,
                startOn,
                endOn,
                error,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MoverOperationStatusError"/>. </summary>
        /// <param name="code"> The error code. </param>
        /// <param name="message"> The error message. </param>
        /// <param name="details"> The error details. </param>
        /// <param name="additionalInfo"> The additional info. </param>
        /// <returns> A new <see cref="Models.MoverOperationStatusError"/> instance for mocking. </returns>
        public static MoverOperationStatusError MoverOperationStatusError(string code = null, string message = null, IEnumerable<MoverOperationStatusError> details = null, IEnumerable<MoverOperationErrorAdditionalInfo> additionalInfo = null)
        {
            details ??= new List<MoverOperationStatusError>();
            additionalInfo ??= new List<MoverOperationErrorAdditionalInfo>();

            return new MoverOperationStatusError(code, message, details?.ToList(), additionalInfo?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MoverOperationErrorAdditionalInfo"/>. </summary>
        /// <param name="operationErrorAdditionalInfoType"> The error type. </param>
        /// <param name="infoMoverResources"> The operation error info. </param>
        /// <returns> A new <see cref="Models.MoverOperationErrorAdditionalInfo"/> instance for mocking. </returns>
        public static MoverOperationErrorAdditionalInfo MoverOperationErrorAdditionalInfo(string operationErrorAdditionalInfoType = null, IEnumerable<AffectedMoverResourceInfo> infoMoverResources = null)
        {
            infoMoverResources ??= new List<AffectedMoverResourceInfo>();

            return new MoverOperationErrorAdditionalInfo(operationErrorAdditionalInfoType, infoMoverResources != null ? new MoveErrorInfo(infoMoverResources?.ToList(), serializedAdditionalRawData: null) : null, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AffectedMoverResourceInfo"/>. </summary>
        /// <param name="id"> The affected move resource id. </param>
        /// <param name="sourceId"> The affected move resource source id. </param>
        /// <param name="moverResources"> The affected move resources. </param>
        /// <returns> A new <see cref="Models.AffectedMoverResourceInfo"/> instance for mocking. </returns>
        public static AffectedMoverResourceInfo AffectedMoverResourceInfo(ResourceIdentifier id = null, ResourceIdentifier sourceId = null, IEnumerable<AffectedMoverResourceInfo> moverResources = null)
        {
            moverResources ??= new List<AffectedMoverResourceInfo>();

            return new AffectedMoverResourceInfo(id, sourceId, moverResources?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="ResourceMover.MoverResourceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> Defines the move resource properties. </param>
        /// <returns> A new <see cref="ResourceMover.MoverResourceData"/> instance for mocking. </returns>
        public static MoverResourceData MoverResourceData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, MoverResourceProperties properties = null)
        {
            return new MoverResourceData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MoverResourceProperties"/>. </summary>
        /// <param name="provisioningState"> Defines the provisioning states. </param>
        /// <param name="sourceId"> Gets or sets the Source ARM Id of the resource. </param>
        /// <param name="targetId"> Gets or sets the Target ARM Id of the resource. </param>
        /// <param name="existingTargetId"> Gets or sets the existing target ARM Id of the resource. </param>
        /// <param name="resourceSettings">
        /// Gets or sets the resource settings.
        /// Please note <see cref="MoverResourceSettings"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="MoverAvailabilitySetResourceSettings"/>, <see cref="DiskEncryptionSetResourceSettings"/>, <see cref="VirtualMachineResourceSettings"/>, <see cref="KeyVaultResourceSettings"/>, <see cref="LoadBalancerResourceSettings"/>, <see cref="NetworkInterfaceResourceSettings"/>, <see cref="NetworkSecurityGroupResourceSettings"/>, <see cref="PublicIPAddressResourceSettings"/>, <see cref="MoverVirtualNetworkResourceSettings"/>, <see cref="SqlServerResourceSettings"/>, <see cref="SqlDatabaseResourceSettings"/>, <see cref="SqlElasticPoolResourceSettings"/> and <see cref="ResourceGroupResourceSettings"/>.
        /// </param>
        /// <param name="sourceResourceSettings">
        /// Gets or sets the source resource settings.
        /// Please note <see cref="MoverResourceSettings"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="MoverAvailabilitySetResourceSettings"/>, <see cref="DiskEncryptionSetResourceSettings"/>, <see cref="VirtualMachineResourceSettings"/>, <see cref="KeyVaultResourceSettings"/>, <see cref="LoadBalancerResourceSettings"/>, <see cref="NetworkInterfaceResourceSettings"/>, <see cref="NetworkSecurityGroupResourceSettings"/>, <see cref="PublicIPAddressResourceSettings"/>, <see cref="MoverVirtualNetworkResourceSettings"/>, <see cref="SqlServerResourceSettings"/>, <see cref="SqlDatabaseResourceSettings"/>, <see cref="SqlElasticPoolResourceSettings"/> and <see cref="ResourceGroupResourceSettings"/>.
        /// </param>
        /// <param name="moveStatus"> Defines the move resource status. </param>
        /// <param name="dependsOn"> Gets or sets the move resource dependencies. </param>
        /// <param name="dependsOnOverrides"> Gets or sets the move resource dependencies overrides. </param>
        /// <param name="isResolveRequired"> Gets a value indicating whether the resolve action is required over the move collection. </param>
        /// <param name="errorsProperties"> Defines the move resource errors. </param>
        /// <returns> A new <see cref="Models.MoverResourceProperties"/> instance for mocking. </returns>
        public static MoverResourceProperties MoverResourceProperties(MoverProvisioningState? provisioningState = null, ResourceIdentifier sourceId = null, ResourceIdentifier targetId = null, ResourceIdentifier existingTargetId = null, MoverResourceSettings resourceSettings = null, MoverResourceSettings sourceResourceSettings = null, MoverResourcePropertiesMoveStatus moveStatus = null, IEnumerable<MoverResourceDependency> dependsOn = null, IEnumerable<MoverResourceDependencyOverride> dependsOnOverrides = null, bool? isResolveRequired = null, ResponseError errorsProperties = null)
        {
            dependsOn ??= new List<MoverResourceDependency>();
            dependsOnOverrides ??= new List<MoverResourceDependencyOverride>();

            return new MoverResourceProperties(
                provisioningState,
                sourceId,
                targetId,
                existingTargetId,
                resourceSettings,
                sourceResourceSettings,
                moveStatus,
                dependsOn?.ToList(),
                dependsOnOverrides?.ToList(),
                isResolveRequired,
                errorsProperties != null ? new MoveResourcePropertiesErrors(errorsProperties, serializedAdditionalRawData: null) : null,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MoverResourcePropertiesMoveStatus"/>. </summary>
        /// <param name="moveState"> Defines the MoveResource states. </param>
        /// <param name="jobStatus"> Defines the job status. </param>
        /// <param name="errorsProperties"> An error response from the azure resource mover service. </param>
        /// <returns> A new <see cref="Models.MoverResourcePropertiesMoveStatus"/> instance for mocking. </returns>
        public static MoverResourcePropertiesMoveStatus MoverResourcePropertiesMoveStatus(MoverResourceMoveState? moveState = null, MoverResourceJobStatus jobStatus = null, ResponseError errorsProperties = null)
        {
            return new MoverResourcePropertiesMoveStatus(moveState, jobStatus, errorsProperties != null ? new MoveResourceError(errorsProperties, serializedAdditionalRawData: null) : null, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MoverResourceStatus"/>. </summary>
        /// <param name="moveState"> Defines the MoveResource states. </param>
        /// <param name="jobStatus"> Defines the job status. </param>
        /// <param name="errorsProperties"> An error response from the azure resource mover service. </param>
        /// <returns> A new <see cref="Models.MoverResourceStatus"/> instance for mocking. </returns>
        public static MoverResourceStatus MoverResourceStatus(MoverResourceMoveState? moveState = null, MoverResourceJobStatus jobStatus = null, ResponseError errorsProperties = null)
        {
            return new MoverResourceStatus(moveState, jobStatus, errorsProperties != null ? new MoveResourceError(errorsProperties, serializedAdditionalRawData: null) : null, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MoverResourceJobStatus"/>. </summary>
        /// <param name="jobName"> Defines the job name. </param>
        /// <param name="jobProgress"> Gets or sets the monitoring job percentage. </param>
        /// <returns> A new <see cref="Models.MoverResourceJobStatus"/> instance for mocking. </returns>
        public static MoverResourceJobStatus MoverResourceJobStatus(MoverResourceJobName? jobName = null, string jobProgress = null)
        {
            return new MoverResourceJobStatus(jobName, jobProgress, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MoverResourceDependency"/>. </summary>
        /// <param name="id"> Gets the source ARM ID of the dependent resource. </param>
        /// <param name="resolutionStatus"> Gets the dependency resolution status. </param>
        /// <param name="resolutionType"> Defines the resolution type. </param>
        /// <param name="dependencyType"> Defines the dependency type. </param>
        /// <param name="manualResolutionTargetId"> Defines the properties for manual resolution. </param>
        /// <param name="automaticResolutionResourceId"> Defines the properties for automatic resolution. </param>
        /// <param name="isDependencyOptional"> Gets or sets a value indicating whether the dependency is optional. </param>
        /// <returns> A new <see cref="Models.MoverResourceDependency"/> instance for mocking. </returns>
        public static MoverResourceDependency MoverResourceDependency(ResourceIdentifier id = null, string resolutionStatus = null, MoverResourceResolutionType? resolutionType = null, MoverDependencyType? dependencyType = null, ResourceIdentifier manualResolutionTargetId = null, ResourceIdentifier automaticResolutionResourceId = null, string isDependencyOptional = null)
        {
            return new MoverResourceDependency(
                id,
                resolutionStatus,
                resolutionType,
                dependencyType,
                manualResolutionTargetId != null ? new ManualResolutionProperties(manualResolutionTargetId, serializedAdditionalRawData: null) : null,
                automaticResolutionResourceId != null ? new AutomaticResolutionProperties(automaticResolutionResourceId, serializedAdditionalRawData: null) : null,
                isDependencyOptional,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MoverUnresolvedDependency"/>. </summary>
        /// <param name="count"> Gets or sets the count. </param>
        /// <param name="id"> Gets or sets the arm id of the dependency. </param>
        /// <returns> A new <see cref="Models.MoverUnresolvedDependency"/> instance for mocking. </returns>
        public static MoverUnresolvedDependency MoverUnresolvedDependency(int? count = null, ResourceIdentifier id = null)
        {
            return new MoverUnresolvedDependency(count, id, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MoverOperationsDiscovery"/>. </summary>
        /// <param name="name">
        /// Gets or sets Name of the API.
        /// The name of the operation being performed on this particular object. It should
        /// match the action name that appears in RBAC / the event service.
        /// Examples of operations include:
        /// * Microsoft.Compute/virtualMachine/capture/action
        /// * Microsoft.Compute/virtualMachine/restart/action
        /// * Microsoft.Compute/virtualMachine/write
        /// * Microsoft.Compute/virtualMachine/read
        /// * Microsoft.Compute/virtualMachine/delete
        /// Each action should include, in order:
        /// (1) Resource Provider Namespace
        /// (2) Type hierarchy for which the action applies (e.g. server/databases for a SQL
        /// Azure database)
        /// (3) Read, Write, Action or Delete indicating which type applies. If it is a PUT/PATCH
        /// on a collection or named value, Write should be used.
        /// If it is a GET, Read should be used. If it is a DELETE, Delete should be used. If it
        /// is a POST, Action should be used.
        /// As a note: all resource providers would need to include the "{Resource Provider
        /// Namespace}/register/action" operation in their response.
        /// This API is used to register for their service, and should include details about the
        /// operation (e.g. a localized name for the resource provider + any special
        /// considerations like PII release).
        /// </param>
        /// <param name="isDataAction"> Indicates whether the operation is a data action. </param>
        /// <param name="display">
        /// Contains the localized display information for this particular operation / action. These
        /// value will be used by several clients for
        /// (1) custom role definitions for RBAC;
        /// (2) complex query filters for the event service; and
        /// (3) audit history / records for management operations.
        /// </param>
        /// <param name="origin">
        /// Gets or sets Origin.
        /// The intended executor of the operation; governs the display of the operation in the
        /// RBAC UX and the audit logs UX.
        /// Default value is "user,system".
        /// </param>
        /// <param name="properties"> ClientDiscovery properties. </param>
        /// <returns> A new <see cref="Models.MoverOperationsDiscovery"/> instance for mocking. </returns>
        public static MoverOperationsDiscovery MoverOperationsDiscovery(string name = null, bool? isDataAction = null, MoverDisplayInfo display = null, string origin = null, BinaryData properties = null)
        {
            return new MoverOperationsDiscovery(
                name,
                isDataAction,
                display,
                origin,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MoverDisplayInfo"/>. </summary>
        /// <param name="provider">
        /// Gets or sets the provider.
        /// The localized friendly form of the resource provider name – it is expected to also
        /// include the publisher/company responsible.
        /// It should use Title Casing and begin with "Microsoft" for 1st party services.
        /// e.g. "Microsoft Monitoring Insights" or "Microsoft Compute.".
        /// </param>
        /// <param name="resource">
        /// Gets or sets the resource.
        /// The localized friendly form of the resource related to this action/operation – it
        /// should match the public documentation for the resource provider.
        /// It should use Title Casing.
        /// This value should be unique for a particular URL type (e.g. nested types should *not*
        /// reuse their parent’s display.resource field)
        /// e.g. "Virtual Machines" or "Scheduler Job Collections", or "Virtual Machine VM Sizes"
        /// or "Scheduler Jobs".
        /// </param>
        /// <param name="operation">
        /// Gets or sets the operation.
        /// The localized friendly name for the operation, as it should be shown to the user.
        /// It should be concise (to fit in drop downs) but clear (i.e. self-documenting).
        /// It should use Title Casing.
        /// Prescriptive guidance: Read Create or Update Delete 'ActionName'.
        /// </param>
        /// <param name="description">
        /// Gets or sets the description.
        /// The localized friendly description for the operation, as it should be shown to the
        /// user.
        /// It should be thorough, yet concise – it will be used in tool tips and detailed views.
        /// Prescriptive guidance for namespace:
        /// Read any 'display.provider'  resource
        /// Create or Update any  'display.provider'  resource
        /// Delete any  'display.provider'  resource
        /// Perform any other action on any  'display.provider'  resource
        /// Prescriptive guidance for namespace:
        /// Read any 'display.resource' Create or Update any  'display.resource' Delete any
        ///  'display.resource' 'ActionName' any 'display.resources'.
        /// </param>
        /// <returns> A new <see cref="Models.MoverDisplayInfo"/> instance for mocking. </returns>
        public static MoverDisplayInfo MoverDisplayInfo(string provider = null, string resource = null, string operation = null, string description = null)
        {
            return new MoverDisplayInfo(provider, resource, operation, description, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RequiredForResourcesList"/>. </summary>
        /// <param name="sourceIds"> Gets or sets the list of source Ids for which the input resource is required. </param>
        /// <returns> A new <see cref="Models.RequiredForResourcesList"/> instance for mocking. </returns>
        public static RequiredForResourcesList RequiredForResourcesList(IEnumerable<string> sourceIds = null)
        {
            sourceIds ??= new List<string>();

            return new RequiredForResourcesList(sourceIds?.ToList(), serializedAdditionalRawData: null);
        }
    }
}
