// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.ResourceMover.Models;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.ResourceMover.Samples
{
    public partial class Sample_MoverResourceSetResource
    {
        // MoveCollections_Update
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_MoveCollectionsUpdate()
        {
            // Generated from example definition: specification/resourcemover/resource-manager/Microsoft.Migrate/stable/2023-08-01/examples/MoveCollections_Update.json
            // this example is just showing the usage of "MoveCollections_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MoverResourceSetResource created on azure
            // for more information of creating MoverResourceSetResource, please refer to the document of MoverResourceSetResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string moverResourceSetName = "movecollection1";
            ResourceIdentifier moverResourceSetResourceId = MoverResourceSetResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, moverResourceSetName);
            MoverResourceSetResource moverResourceSet = client.GetMoverResourceSetResource(moverResourceSetResourceId);

            // invoke the operation
            MoverResourceSetPatch patch = new MoverResourceSetPatch()
            {
                Tags =
{
["key1"] = "mc1",
},
                Identity = new ManagedServiceIdentity("SystemAssigned"),
            };
            MoverResourceSetResource result = await moverResourceSet.UpdateAsync(patch);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MoverResourceSetData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // MoveCollections_Delete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_MoveCollectionsDelete()
        {
            // Generated from example definition: specification/resourcemover/resource-manager/Microsoft.Migrate/stable/2023-08-01/examples/MoveCollections_Delete.json
            // this example is just showing the usage of "MoveCollections_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MoverResourceSetResource created on azure
            // for more information of creating MoverResourceSetResource, please refer to the document of MoverResourceSetResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string moverResourceSetName = "movecollection1";
            ResourceIdentifier moverResourceSetResourceId = MoverResourceSetResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, moverResourceSetName);
            MoverResourceSetResource moverResourceSet = client.GetMoverResourceSetResource(moverResourceSetResourceId);

            // invoke the operation
            ArmOperation<MoverOperationStatus> lro = await moverResourceSet.DeleteAsync(WaitUntil.Completed);
            MoverOperationStatus result = lro.Value;

            Console.WriteLine($"Succeeded: {result}");
        }

        // MoveCollections_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_MoveCollectionsGet()
        {
            // Generated from example definition: specification/resourcemover/resource-manager/Microsoft.Migrate/stable/2023-08-01/examples/MoveCollections_Get.json
            // this example is just showing the usage of "MoveCollections_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MoverResourceSetResource created on azure
            // for more information of creating MoverResourceSetResource, please refer to the document of MoverResourceSetResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string moverResourceSetName = "movecollection1";
            ResourceIdentifier moverResourceSetResourceId = MoverResourceSetResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, moverResourceSetName);
            MoverResourceSetResource moverResourceSet = client.GetMoverResourceSetResource(moverResourceSetResourceId);

            // invoke the operation
            MoverResourceSetResource result = await moverResourceSet.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MoverResourceSetData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // MoveCollections_Prepare
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Prepare_MoveCollectionsPrepare()
        {
            // Generated from example definition: specification/resourcemover/resource-manager/Microsoft.Migrate/stable/2023-08-01/examples/MoveCollections_Prepare.json
            // this example is just showing the usage of "MoveCollections_Prepare" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MoverResourceSetResource created on azure
            // for more information of creating MoverResourceSetResource, please refer to the document of MoverResourceSetResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string moverResourceSetName = "movecollection1";
            ResourceIdentifier moverResourceSetResourceId = MoverResourceSetResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, moverResourceSetName);
            MoverResourceSetResource moverResourceSet = client.GetMoverResourceSetResource(moverResourceSetResourceId);

            // invoke the operation
            MoverPrepareContent content = new MoverPrepareContent(new ResourceIdentifier[]
            {
new ResourceIdentifier("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Migrate/MoveCollections/movecollection1/MoveResources/moveresource1")
            })
            {
                ValidateOnly = false,
            };
            ArmOperation<MoverOperationStatus> lro = await moverResourceSet.PrepareAsync(WaitUntil.Completed, content: content);
            MoverOperationStatus result = lro.Value;

            Console.WriteLine($"Succeeded: {result}");
        }

        // MoveCollections_InitiateMove
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task InitiateMove_MoveCollectionsInitiateMove()
        {
            // Generated from example definition: specification/resourcemover/resource-manager/Microsoft.Migrate/stable/2023-08-01/examples/MoveCollections_InitiateMove.json
            // this example is just showing the usage of "MoveCollections_InitiateMove" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MoverResourceSetResource created on azure
            // for more information of creating MoverResourceSetResource, please refer to the document of MoverResourceSetResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string moverResourceSetName = "movecollection1";
            ResourceIdentifier moverResourceSetResourceId = MoverResourceSetResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, moverResourceSetName);
            MoverResourceSetResource moverResourceSet = client.GetMoverResourceSetResource(moverResourceSetResourceId);

            // invoke the operation
            MoverResourceMoveContent content = new MoverResourceMoveContent(new ResourceIdentifier[]
            {
new ResourceIdentifier("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Migrate/MoveCollections/movecollection1/MoveResources/moveresource1")
            })
            {
                ValidateOnly = false,
            };
            ArmOperation<MoverOperationStatus> lro = await moverResourceSet.InitiateMoveAsync(WaitUntil.Completed, content: content);
            MoverOperationStatus result = lro.Value;

            Console.WriteLine($"Succeeded: {result}");
        }

        // MoveCollections_Commit
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Commit_MoveCollectionsCommit()
        {
            // Generated from example definition: specification/resourcemover/resource-manager/Microsoft.Migrate/stable/2023-08-01/examples/MoveCollections_Commit.json
            // this example is just showing the usage of "MoveCollections_Commit" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MoverResourceSetResource created on azure
            // for more information of creating MoverResourceSetResource, please refer to the document of MoverResourceSetResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string moverResourceSetName = "movecollection1";
            ResourceIdentifier moverResourceSetResourceId = MoverResourceSetResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, moverResourceSetName);
            MoverResourceSetResource moverResourceSet = client.GetMoverResourceSetResource(moverResourceSetResourceId);

            // invoke the operation
            MoverCommitContent content = new MoverCommitContent(new ResourceIdentifier[]
            {
new ResourceIdentifier("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Migrate/MoveCollections/movecollection1/MoveResources/moveresource1")
            })
            {
                ValidateOnly = false,
            };
            ArmOperation<MoverOperationStatus> lro = await moverResourceSet.CommitAsync(WaitUntil.Completed, content: content);
            MoverOperationStatus result = lro.Value;

            Console.WriteLine($"Succeeded: {result}");
        }

        // MoveCollections_Discard
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Discard_MoveCollectionsDiscard()
        {
            // Generated from example definition: specification/resourcemover/resource-manager/Microsoft.Migrate/stable/2023-08-01/examples/MoveCollections_Discard.json
            // this example is just showing the usage of "MoveCollections_Discard" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MoverResourceSetResource created on azure
            // for more information of creating MoverResourceSetResource, please refer to the document of MoverResourceSetResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string moverResourceSetName = "movecollection1";
            ResourceIdentifier moverResourceSetResourceId = MoverResourceSetResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, moverResourceSetName);
            MoverResourceSetResource moverResourceSet = client.GetMoverResourceSetResource(moverResourceSetResourceId);

            // invoke the operation
            MoverDiscardContent content = new MoverDiscardContent(new ResourceIdentifier[]
            {
new ResourceIdentifier("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Migrate/MoveCollections/movecollection1/MoveResources/moveresource1")
            })
            {
                ValidateOnly = false,
            };
            ArmOperation<MoverOperationStatus> lro = await moverResourceSet.DiscardAsync(WaitUntil.Completed, content: content);
            MoverOperationStatus result = lro.Value;

            Console.WriteLine($"Succeeded: {result}");
        }

        // MoveCollections_ResolveDependencies
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task ResolveDependencies_MoveCollectionsResolveDependencies()
        {
            // Generated from example definition: specification/resourcemover/resource-manager/Microsoft.Migrate/stable/2023-08-01/examples/MoveCollections_ResolveDependencies.json
            // this example is just showing the usage of "MoveCollections_ResolveDependencies" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MoverResourceSetResource created on azure
            // for more information of creating MoverResourceSetResource, please refer to the document of MoverResourceSetResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string moverResourceSetName = "movecollection1";
            ResourceIdentifier moverResourceSetResourceId = MoverResourceSetResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, moverResourceSetName);
            MoverResourceSetResource moverResourceSet = client.GetMoverResourceSetResource(moverResourceSetResourceId);

            // invoke the operation
            ArmOperation<MoverOperationStatus> lro = await moverResourceSet.ResolveDependenciesAsync(WaitUntil.Completed);
            MoverOperationStatus result = lro.Value;

            Console.WriteLine($"Succeeded: {result}");
        }

        // MoveCollections_BulkRemove
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task BulkRemove_MoveCollectionsBulkRemove()
        {
            // Generated from example definition: specification/resourcemover/resource-manager/Microsoft.Migrate/stable/2023-08-01/examples/MoveCollections_BulkRemove.json
            // this example is just showing the usage of "MoveCollections_BulkRemove" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MoverResourceSetResource created on azure
            // for more information of creating MoverResourceSetResource, please refer to the document of MoverResourceSetResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string moverResourceSetName = "movecollection1";
            ResourceIdentifier moverResourceSetResourceId = MoverResourceSetResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, moverResourceSetName);
            MoverResourceSetResource moverResourceSet = client.GetMoverResourceSetResource(moverResourceSetResourceId);

            // invoke the operation
            MoverBulkRemoveContent content = new MoverBulkRemoveContent()
            {
                ValidateOnly = false,
                MoverResources =
{
new ResourceIdentifier("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Migrate/MoveCollections/movecollection1/MoveResources/moveresource1")
},
            };
            ArmOperation<MoverOperationStatus> lro = await moverResourceSet.BulkRemoveAsync(WaitUntil.Completed, content: content);
            MoverOperationStatus result = lro.Value;

            Console.WriteLine($"Succeeded: {result}");
        }

        // MoveCollections_ListMoveCollectionsBySubscription
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetMoverResourceSets_MoveCollectionsListMoveCollectionsBySubscription()
        {
            // Generated from example definition: specification/resourcemover/resource-manager/Microsoft.Migrate/stable/2023-08-01/examples/MoveCollections_ListMoveCollectionsBySubscription.json
            // this example is just showing the usage of "MoveCollections_ListMoveCollectionsBySubscription" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "subid";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation and iterate over the result
            await foreach (MoverResourceSetResource item in subscriptionResource.GetMoverResourceSetsAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                MoverResourceSetData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // RequiredFor_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetRequiredForResources_RequiredForGet()
        {
            // Generated from example definition: specification/resourcemover/resource-manager/Microsoft.Migrate/stable/2023-08-01/examples/RequiredFor_Get.json
            // this example is just showing the usage of "MoveCollections_ListRequiredFor" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MoverResourceSetResource created on azure
            // for more information of creating MoverResourceSetResource, please refer to the document of MoverResourceSetResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string moverResourceSetName = "movecollection1";
            ResourceIdentifier moverResourceSetResourceId = MoverResourceSetResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, moverResourceSetName);
            MoverResourceSetResource moverResourceSet = client.GetMoverResourceSetResource(moverResourceSetResourceId);

            // invoke the operation
            ResourceIdentifier sourceId = new ResourceIdentifier("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/nic1");
            RequiredForResourcesList result = await moverResourceSet.GetRequiredForResourcesAsync(sourceId);

            Console.WriteLine($"Succeeded: {result}");
        }

        // UnresolvedDependencies_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetUnresolvedDependencies_UnresolvedDependenciesGet()
        {
            // Generated from example definition: specification/resourcemover/resource-manager/Microsoft.Migrate/stable/2023-08-01/examples/UnresolvedDependencies_Get.json
            // this example is just showing the usage of "UnresolvedDependencies_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MoverResourceSetResource created on azure
            // for more information of creating MoverResourceSetResource, please refer to the document of MoverResourceSetResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string moverResourceSetName = "movecollection1";
            ResourceIdentifier moverResourceSetResourceId = MoverResourceSetResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, moverResourceSetName);
            MoverResourceSetResource moverResourceSet = client.GetMoverResourceSetResource(moverResourceSetResourceId);

            // invoke the operation and iterate over the result
            await foreach (MoverUnresolvedDependency item in moverResourceSet.GetUnresolvedDependenciesAsync())
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
