// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.ResourceMover.Models;

namespace Azure.ResourceManager.ResourceMover.Samples
{
    public partial class Sample_MoverResource
    {
        // MoveResources_Create
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_MoveResourcesCreate()
        {
            // Generated from example definition: specification/resourcemover/resource-manager/Microsoft.Migrate/stable/2023-08-01/examples/MoveResources_Create.json
            // this example is just showing the usage of "MoveResources_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MoverResource created on azure
            // for more information of creating MoverResource, please refer to the document of MoverResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string moverResourceSetName = "movecollection1";
            string moverResourceName = "moveresourcename1";
            ResourceIdentifier moverResourceId = MoverResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, moverResourceSetName, moverResourceName);
            MoverResource moverResource = client.GetMoverResource(moverResourceId);

            // invoke the operation
            MoverResourceData data = new MoverResourceData()
            {
                Properties = new MoverResourceProperties(new ResourceIdentifier("/subscriptions/subid/resourceGroups/eastusRG/providers/Microsoft.Compute/virtualMachines/eastusvm1"))
                {
                    ResourceSettings = new VirtualMachineResourceSettings()
                    {
                        UserManagedIdentities =
{
new ResourceIdentifier("/subscriptions/subid/resourceGroups/eastusRG/providers/Microsoft.ManagedIdentity/userAssignedIdentities/umi1")
},
                        TargetAvailabilityZone = MoverTargetAvailabilityZone.Two,
                        TargetVmSize = null,
                        TargetAvailabilitySetId = new ResourceIdentifier("/subscriptions/subid/resourceGroups/eastusRG/providers/Microsoft.Compute/availabilitySets/avset1"),
                        TargetResourceName = "westusvm1",
                    },
                    DependsOnOverrides =
{
new MoverResourceDependencyOverride()
{
Id = new ResourceIdentifier("/subscriptions/c4488a3f-a7f7-4ad4-aa72-0e1f4d9c0756/resourceGroups/eastusRG/providers/Microsoft.Network/networkInterfaces/eastusvm140"),
TargetId = new ResourceIdentifier("/subscriptions/c4488a3f-a7f7-4ad4-aa72-0e1f4d9c0756/resourceGroups/westusRG/providers/Microsoft.Network/networkInterfaces/eastusvm140"),
}
},
                },
            };
            ArmOperation<MoverResource> lro = await moverResource.UpdateAsync(WaitUntil.Completed, data);
            MoverResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MoverResourceData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // MoveResources_Delete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_MoveResourcesDelete()
        {
            // Generated from example definition: specification/resourcemover/resource-manager/Microsoft.Migrate/stable/2023-08-01/examples/MoveResources_Delete.json
            // this example is just showing the usage of "MoveResources_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MoverResource created on azure
            // for more information of creating MoverResource, please refer to the document of MoverResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string moverResourceSetName = "movecollection1";
            string moverResourceName = "moveresourcename1";
            ResourceIdentifier moverResourceId = MoverResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, moverResourceSetName, moverResourceName);
            MoverResource moverResource = client.GetMoverResource(moverResourceId);

            // invoke the operation
            ArmOperation<MoverOperationStatus> lro = await moverResource.DeleteAsync(WaitUntil.Completed);
            MoverOperationStatus result = lro.Value;

            Console.WriteLine($"Succeeded: {result}");
        }

        // MoveResources_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_MoveResourcesGet()
        {
            // Generated from example definition: specification/resourcemover/resource-manager/Microsoft.Migrate/stable/2023-08-01/examples/MoveResources_Get.json
            // this example is just showing the usage of "MoveResources_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MoverResource created on azure
            // for more information of creating MoverResource, please refer to the document of MoverResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg1";
            string moverResourceSetName = "movecollection1";
            string moverResourceName = "moveresourcename1";
            ResourceIdentifier moverResourceId = MoverResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, moverResourceSetName, moverResourceName);
            MoverResource moverResource = client.GetMoverResource(moverResourceId);

            // invoke the operation
            MoverResource result = await moverResource.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MoverResourceData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
