// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.Resources
{
    /// <summary>
    /// A class representing the PolicySetDefinition data model.
    /// The policy set definition.
    /// </summary>
    public partial class PolicySetDefinitionData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PolicySetDefinitionData"/>. </summary>
        public PolicySetDefinitionData()
        {
            Parameters = new ChangeTrackingDictionary<string, ArmPolicyParameter>();
            PolicyDefinitions = new ChangeTrackingList<PolicyDefinitionReference>();
            PolicyDefinitionGroups = new ChangeTrackingList<PolicyDefinitionGroup>();
        }

        /// <summary> Initializes a new instance of <see cref="PolicySetDefinitionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="policyType"> The type of policy definition. Possible values are NotSpecified, BuiltIn, Custom, and Static. </param>
        /// <param name="displayName"> The display name of the policy set definition. </param>
        /// <param name="description"> The policy set definition description. </param>
        /// <param name="metadata"> The policy set definition metadata.  Metadata is an open ended object and is typically a collection of key value pairs. </param>
        /// <param name="parameters"> The policy set definition parameters that can be used in policy definition references. </param>
        /// <param name="policyDefinitions"> An array of policy definition references. </param>
        /// <param name="policyDefinitionGroups"> The metadata describing groups of policy definition references within the policy set definition. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PolicySetDefinitionData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, PolicyType? policyType, string displayName, string description, BinaryData metadata, IDictionary<string, ArmPolicyParameter> parameters, IList<PolicyDefinitionReference> policyDefinitions, IList<PolicyDefinitionGroup> policyDefinitionGroups, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            PolicyType = policyType;
            DisplayName = displayName;
            Description = description;
            Metadata = metadata;
            Parameters = parameters;
            PolicyDefinitions = policyDefinitions;
            PolicyDefinitionGroups = policyDefinitionGroups;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The type of policy definition. Possible values are NotSpecified, BuiltIn, Custom, and Static. </summary>
        [WirePath("properties.policyType")]
        public PolicyType? PolicyType { get; set; }
        /// <summary> The display name of the policy set definition. </summary>
        [WirePath("properties.displayName")]
        public string DisplayName { get; set; }
        /// <summary> The policy set definition description. </summary>
        [WirePath("properties.description")]
        public string Description { get; set; }
        /// <summary>
        /// The policy set definition metadata.  Metadata is an open ended object and is typically a collection of key value pairs.
        /// <para>
        /// To assign an object to this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        [WirePath("properties.metadata")]
        public BinaryData Metadata { get; set; }
        /// <summary> The policy set definition parameters that can be used in policy definition references. </summary>
        [WirePath("properties.parameters")]
        public IDictionary<string, ArmPolicyParameter> Parameters { get; }
        /// <summary> An array of policy definition references. </summary>
        [WirePath("properties.policyDefinitions")]
        public IList<PolicyDefinitionReference> PolicyDefinitions { get; }
        /// <summary> The metadata describing groups of policy definition references within the policy set definition. </summary>
        [WirePath("properties.policyDefinitionGroups")]
        public IList<PolicyDefinitionGroup> PolicyDefinitionGroups { get; }
    }
}
