// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Resources.Models
{
    internal static partial class TenantCategoryExtensions
    {
        public static string ToSerialString(this TenantCategory value) => value switch
        {
            TenantCategory.Home => "Home",
            TenantCategory.ProjectedBy => "ProjectedBy",
            TenantCategory.ManagedBy => "ManagedBy",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown TenantCategory value.")
        };

        public static TenantCategory ToTenantCategory(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Home")) return TenantCategory.Home;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "ProjectedBy")) return TenantCategory.ProjectedBy;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "ManagedBy")) return TenantCategory.ManagedBy;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown TenantCategory value.");
        }
    }
}
