// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Resources.Models
{
    /// <summary> Wrapper resource for tags patch API request only. </summary>
    public partial class TagResourcePatch
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="TagResourcePatch"/>. </summary>
        public TagResourcePatch()
        {
        }

        /// <summary> Initializes a new instance of <see cref="TagResourcePatch"/>. </summary>
        /// <param name="patchMode"> The operation type for the patch API. </param>
        /// <param name="properties"> The set of tags. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal TagResourcePatch(TagPatchMode? patchMode, Tag properties, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PatchMode = patchMode;
            Properties = properties;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The operation type for the patch API. </summary>
        [WirePath("operation")]
        public TagPatchMode? PatchMode { get; set; }
        /// <summary> The set of tags. </summary>
        internal Tag Properties { get; set; }
        /// <summary> Dictionary of &lt;string&gt;. </summary>
        [WirePath("properties.tags")]
        public IDictionary<string, string> TagValues
        {
            get
            {
                if (Properties is null)
                    Properties = new Tag();
                return Properties.TagValues;
            }
        }
    }
}
