// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Resources.Models
{
    /// <summary> The operation type for the patch API. </summary>
    public readonly partial struct TagPatchMode : IEquatable<TagPatchMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="TagPatchMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public TagPatchMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ReplaceValue = "Replace";
        private const string MergeValue = "Merge";
        private const string DeleteValue = "Delete";

        /// <summary> The 'replace' option replaces the entire set of existing tags with a new set. </summary>
        public static TagPatchMode Replace { get; } = new TagPatchMode(ReplaceValue);
        /// <summary> The 'merge' option allows adding tags with new names and updating the values of tags with existing names. </summary>
        public static TagPatchMode Merge { get; } = new TagPatchMode(MergeValue);
        /// <summary> The 'delete' option allows selectively deleting tags based on given names or name/value pairs. </summary>
        public static TagPatchMode Delete { get; } = new TagPatchMode(DeleteValue);
        /// <summary> Determines if two <see cref="TagPatchMode"/> values are the same. </summary>
        public static bool operator ==(TagPatchMode left, TagPatchMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="TagPatchMode"/> values are not the same. </summary>
        public static bool operator !=(TagPatchMode left, TagPatchMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="TagPatchMode"/>. </summary>
        public static implicit operator TagPatchMode(string value) => new TagPatchMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is TagPatchMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(TagPatchMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
