// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Resources.Models
{
    /// <summary> The type of the pattern for an alias path. </summary>
    public partial class ResourceTypeAliasPattern
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ResourceTypeAliasPattern"/>. </summary>
        internal ResourceTypeAliasPattern()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ResourceTypeAliasPattern"/>. </summary>
        /// <param name="phrase"> The alias pattern phrase. </param>
        /// <param name="variable"> The alias pattern variable. </param>
        /// <param name="patternType"> The type of alias pattern. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ResourceTypeAliasPattern(string phrase, string variable, ResourceTypeAliasPatternType? patternType, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Phrase = phrase;
            Variable = variable;
            PatternType = patternType;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The alias pattern phrase. </summary>
        [WirePath("phrase")]
        public string Phrase { get; }
        /// <summary> The alias pattern variable. </summary>
        [WirePath("variable")]
        public string Variable { get; }
        /// <summary> The type of alias pattern. </summary>
        [WirePath("type")]
        public ResourceTypeAliasPatternType? PatternType { get; }
    }
}
