// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Resources.Models
{
    /// <summary> The selector kind. </summary>
    public readonly partial struct ResourceSelectorKind : IEquatable<ResourceSelectorKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ResourceSelectorKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ResourceSelectorKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ResourceLocationValue = "resourceLocation";
        private const string ResourceTypeValue = "resourceType";
        private const string ResourceWithoutLocationValue = "resourceWithoutLocation";
        private const string PolicyDefinitionReferenceIdValue = "policyDefinitionReferenceId";

        /// <summary> The selector kind to filter policies by the resource location. </summary>
        public static ResourceSelectorKind ResourceLocation { get; } = new ResourceSelectorKind(ResourceLocationValue);
        /// <summary> The selector kind to filter policies by the resource type. </summary>
        public static ResourceSelectorKind ResourceType { get; } = new ResourceSelectorKind(ResourceTypeValue);
        /// <summary> The selector kind to filter policies by the resource without location. </summary>
        public static ResourceSelectorKind ResourceWithoutLocation { get; } = new ResourceSelectorKind(ResourceWithoutLocationValue);
        /// <summary> The selector kind to filter policies by the policy definition reference ID. </summary>
        public static ResourceSelectorKind PolicyDefinitionReferenceId { get; } = new ResourceSelectorKind(PolicyDefinitionReferenceIdValue);
        /// <summary> Determines if two <see cref="ResourceSelectorKind"/> values are the same. </summary>
        public static bool operator ==(ResourceSelectorKind left, ResourceSelectorKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ResourceSelectorKind"/> values are not the same. </summary>
        public static bool operator !=(ResourceSelectorKind left, ResourceSelectorKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ResourceSelectorKind"/>. </summary>
        public static implicit operator ResourceSelectorKind(string value) => new ResourceSelectorKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ResourceSelectorKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ResourceSelectorKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
