// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Resources.Models
{
    /// <summary> The selector expression. </summary>
    public partial class ResourceSelectorExpression
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ResourceSelectorExpression"/>. </summary>
        public ResourceSelectorExpression()
        {
            In = new ChangeTrackingList<string>();
            NotIn = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="ResourceSelectorExpression"/>. </summary>
        /// <param name="kind"> The selector kind. </param>
        /// <param name="in"> The list of values to filter in. </param>
        /// <param name="notIn"> The list of values to filter out. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ResourceSelectorExpression(ResourceSelectorKind? kind, IList<string> @in, IList<string> notIn, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Kind = kind;
            In = @in;
            NotIn = notIn;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The selector kind. </summary>
        [WirePath("kind")]
        public ResourceSelectorKind? Kind { get; set; }
        /// <summary> The list of values to filter in. </summary>
        [WirePath("in")]
        public IList<string> In { get; }
        /// <summary> The list of values to filter out. </summary>
        [WirePath("notIn")]
        public IList<string> NotIn { get; }
    }
}
