// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Resources.Models
{
    /// <summary> The resource selector to filter policies by resource properties. </summary>
    public partial class ResourceSelector
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ResourceSelector"/>. </summary>
        public ResourceSelector()
        {
            Selectors = new ChangeTrackingList<ResourceSelectorExpression>();
        }

        /// <summary> Initializes a new instance of <see cref="ResourceSelector"/>. </summary>
        /// <param name="name"> The name of the resource selector. </param>
        /// <param name="selectors"> The list of the selector expressions. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ResourceSelector(string name, IList<ResourceSelectorExpression> selectors, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            Selectors = selectors;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The name of the resource selector. </summary>
        [WirePath("name")]
        public string Name { get; set; }
        /// <summary> The list of the selector expressions. </summary>
        [WirePath("selectors")]
        public IList<ResourceSelectorExpression> Selectors { get; }
    }
}
