// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Resources.Models
{
    /// <summary> Is the resource name Allowed or Reserved. </summary>
    public readonly partial struct ResourceNameValidationStatus : IEquatable<ResourceNameValidationStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ResourceNameValidationStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ResourceNameValidationStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AllowedValue = "Allowed";
        private const string ReservedValue = "Reserved";

        /// <summary> Allowed. </summary>
        public static ResourceNameValidationStatus Allowed { get; } = new ResourceNameValidationStatus(AllowedValue);
        /// <summary> Reserved. </summary>
        public static ResourceNameValidationStatus Reserved { get; } = new ResourceNameValidationStatus(ReservedValue);
        /// <summary> Determines if two <see cref="ResourceNameValidationStatus"/> values are the same. </summary>
        public static bool operator ==(ResourceNameValidationStatus left, ResourceNameValidationStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ResourceNameValidationStatus"/> values are not the same. </summary>
        public static bool operator !=(ResourceNameValidationStatus left, ResourceNameValidationStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ResourceNameValidationStatus"/>. </summary>
        public static implicit operator ResourceNameValidationStatus(string value) => new ResourceNameValidationStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ResourceNameValidationStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ResourceNameValidationStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
