// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Resources.Models
{
    /// <summary> Resource Name valid if not a reserved word, does not contain a reserved word and does not start with a reserved word. </summary>
    public partial class ResourceNameValidationResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ResourceNameValidationResult"/>. </summary>
        internal ResourceNameValidationResult()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ResourceNameValidationResult"/>. </summary>
        /// <param name="name"> Name of Resource. </param>
        /// <param name="resourceType"> Type of Resource. </param>
        /// <param name="status"> Is the resource name Allowed or Reserved. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ResourceNameValidationResult(string name, ResourceType? resourceType, ResourceNameValidationStatus? status, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            ResourceType = resourceType;
            Status = status;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Name of Resource. </summary>
        [WirePath("name")]
        public string Name { get; }
        /// <summary> Type of Resource. </summary>
        [WirePath("type")]
        public ResourceType? ResourceType { get; }
        /// <summary> Is the resource name Allowed or Reserved. </summary>
        [WirePath("status")]
        public ResourceNameValidationStatus? Status { get; }
    }
}
