// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Resources.Models
{
    /// <summary> Tag information. </summary>
    public partial class PredefinedTagValue
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PredefinedTagValue"/>. </summary>
        internal PredefinedTagValue()
        {
        }

        /// <summary> Initializes a new instance of <see cref="PredefinedTagValue"/>. </summary>
        /// <param name="id"> The tag value ID. </param>
        /// <param name="tagValue"> The tag value. </param>
        /// <param name="count"> The tag value count. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PredefinedTagValue(string id, string tagValue, PredefinedTagCount count, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Id = id;
            TagValue = tagValue;
            Count = count;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The tag value ID. </summary>
        [WirePath("id")]
        public string Id { get; }
        /// <summary> The tag value. </summary>
        [WirePath("tagValue")]
        public string TagValue { get; }
        /// <summary> The tag value count. </summary>
        [WirePath("count")]
        public PredefinedTagCount Count { get; }
    }
}
