// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Resources.Models
{
    /// <summary> The override kind. </summary>
    public readonly partial struct PolicyOverrideKind : IEquatable<PolicyOverrideKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PolicyOverrideKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PolicyOverrideKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PolicyEffectValue = "policyEffect";

        /// <summary> It will override the policy effect type. </summary>
        public static PolicyOverrideKind PolicyEffect { get; } = new PolicyOverrideKind(PolicyEffectValue);
        /// <summary> Determines if two <see cref="PolicyOverrideKind"/> values are the same. </summary>
        public static bool operator ==(PolicyOverrideKind left, PolicyOverrideKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PolicyOverrideKind"/> values are not the same. </summary>
        public static bool operator !=(PolicyOverrideKind left, PolicyOverrideKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PolicyOverrideKind"/>. </summary>
        public static implicit operator PolicyOverrideKind(string value) => new PolicyOverrideKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PolicyOverrideKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PolicyOverrideKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
