// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Resources.Models
{
    /// <summary> The policy definition reference. </summary>
    public partial class PolicyDefinitionReference
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PolicyDefinitionReference"/>. </summary>
        /// <param name="policyDefinitionId"> The ID of the policy definition or policy set definition. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="policyDefinitionId"/> is null. </exception>
        public PolicyDefinitionReference(string policyDefinitionId)
        {
            Argument.AssertNotNull(policyDefinitionId, nameof(policyDefinitionId));

            PolicyDefinitionId = policyDefinitionId;
            Parameters = new ChangeTrackingDictionary<string, ArmPolicyParameterValue>();
            GroupNames = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="PolicyDefinitionReference"/>. </summary>
        /// <param name="policyDefinitionId"> The ID of the policy definition or policy set definition. </param>
        /// <param name="parameters"> The parameter values for the referenced policy rule. The keys are the parameter names. </param>
        /// <param name="policyDefinitionReferenceId"> A unique id (within the policy set definition) for this policy definition reference. </param>
        /// <param name="groupNames"> The name of the groups that this policy definition reference belongs to. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PolicyDefinitionReference(string policyDefinitionId, IDictionary<string, ArmPolicyParameterValue> parameters, string policyDefinitionReferenceId, IList<string> groupNames, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PolicyDefinitionId = policyDefinitionId;
            Parameters = parameters;
            PolicyDefinitionReferenceId = policyDefinitionReferenceId;
            GroupNames = groupNames;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="PolicyDefinitionReference"/> for deserialization. </summary>
        internal PolicyDefinitionReference()
        {
        }

        /// <summary> The ID of the policy definition or policy set definition. </summary>
        [WirePath("policyDefinitionId")]
        public string PolicyDefinitionId { get; set; }
        /// <summary> The parameter values for the referenced policy rule. The keys are the parameter names. </summary>
        [WirePath("parameters")]
        public IDictionary<string, ArmPolicyParameterValue> Parameters { get; }
        /// <summary> A unique id (within the policy set definition) for this policy definition reference. </summary>
        [WirePath("policyDefinitionReferenceId")]
        public string PolicyDefinitionReferenceId { get; set; }
        /// <summary> The name of the groups that this policy definition reference belongs to. </summary>
        [WirePath("groupNames")]
        public IList<string> GroupNames { get; }
    }
}
