// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Resources.Models
{
    /// <summary> The policy definition group. </summary>
    public partial class PolicyDefinitionGroup
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PolicyDefinitionGroup"/>. </summary>
        /// <param name="name"> The name of the group. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/> is null. </exception>
        public PolicyDefinitionGroup(string name)
        {
            Argument.AssertNotNull(name, nameof(name));

            Name = name;
        }

        /// <summary> Initializes a new instance of <see cref="PolicyDefinitionGroup"/>. </summary>
        /// <param name="name"> The name of the group. </param>
        /// <param name="displayName"> The group's display name. </param>
        /// <param name="category"> The group's category. </param>
        /// <param name="description"> The group's description. </param>
        /// <param name="additionalMetadataId"> A resource ID of a resource that contains additional metadata about the group. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PolicyDefinitionGroup(string name, string displayName, string category, string description, string additionalMetadataId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            DisplayName = displayName;
            Category = category;
            Description = description;
            AdditionalMetadataId = additionalMetadataId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="PolicyDefinitionGroup"/> for deserialization. </summary>
        internal PolicyDefinitionGroup()
        {
        }

        /// <summary> The name of the group. </summary>
        [WirePath("name")]
        public string Name { get; set; }
        /// <summary> The group's display name. </summary>
        [WirePath("displayName")]
        public string DisplayName { get; set; }
        /// <summary> The group's category. </summary>
        [WirePath("category")]
        public string Category { get; set; }
        /// <summary> The group's description. </summary>
        [WirePath("description")]
        public string Description { get; set; }
        /// <summary> A resource ID of a resource that contains additional metadata about the group. </summary>
        [WirePath("additionalMetadataId")]
        public string AdditionalMetadataId { get; set; }
    }
}
