// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Resources.Models
{
    /// <summary> The policy assignment for Patch request. </summary>
    public partial class PolicyAssignmentPatch
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PolicyAssignmentPatch"/>. </summary>
        public PolicyAssignmentPatch()
        {
            ResourceSelectors = new ChangeTrackingList<ResourceSelector>();
            Overrides = new ChangeTrackingList<PolicyOverride>();
        }

        /// <summary> Initializes a new instance of <see cref="PolicyAssignmentPatch"/>. </summary>
        /// <param name="location"> The location of the policy assignment. Only required when utilizing managed identity. </param>
        /// <param name="identity"> The managed identity associated with the policy assignment. Current supported identity types: None, SystemAssigned, UserAssigned. </param>
        /// <param name="resourceSelectors"> The resource selector list to filter policies by resource properties. </param>
        /// <param name="overrides"> The policy property value override. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PolicyAssignmentPatch(AzureLocation? location, ManagedServiceIdentity identity, IList<ResourceSelector> resourceSelectors, IList<PolicyOverride> overrides, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Location = location;
            Identity = identity;
            ResourceSelectors = resourceSelectors;
            Overrides = overrides;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The location of the policy assignment. Only required when utilizing managed identity. </summary>
        [WirePath("location")]
        public AzureLocation? Location { get; set; }
        /// <summary> The managed identity associated with the policy assignment. Current supported identity types: None, SystemAssigned, UserAssigned. </summary>
        [WirePath("identity")]
        public ManagedServiceIdentity Identity { get; set; }
        /// <summary> The resource selector list to filter policies by resource properties. </summary>
        [WirePath("properties.resourceSelectors")]
        public IList<ResourceSelector> ResourceSelectors { get; }
        /// <summary> The policy property value override. </summary>
        [WirePath("properties.overrides")]
        public IList<PolicyOverride> Overrides { get; }
    }
}
