// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Resources.Models
{
    /// <summary> The level of the lock. Possible values are: NotSpecified, CanNotDelete, ReadOnly. CanNotDelete means authorized users are able to read and modify the resources, but not delete. ReadOnly means authorized users can only read from a resource, but they can't modify or delete it. </summary>
    public readonly partial struct ManagementLockLevel : IEquatable<ManagementLockLevel>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ManagementLockLevel"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ManagementLockLevel(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotSpecifiedValue = "NotSpecified";
        private const string CanNotDeleteValue = "CanNotDelete";
        private const string ReadOnlyValue = "ReadOnly";

        /// <summary> NotSpecified. </summary>
        public static ManagementLockLevel NotSpecified { get; } = new ManagementLockLevel(NotSpecifiedValue);
        /// <summary> CanNotDelete. </summary>
        public static ManagementLockLevel CanNotDelete { get; } = new ManagementLockLevel(CanNotDeleteValue);
        /// <summary> ReadOnly. </summary>
        public static ManagementLockLevel ReadOnly { get; } = new ManagementLockLevel(ReadOnlyValue);
        /// <summary> Determines if two <see cref="ManagementLockLevel"/> values are the same. </summary>
        public static bool operator ==(ManagementLockLevel left, ManagementLockLevel right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ManagementLockLevel"/> values are not the same. </summary>
        public static bool operator !=(ManagementLockLevel left, ManagementLockLevel right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ManagementLockLevel"/>. </summary>
        public static implicit operator ManagementLockLevel(string value) => new ManagementLockLevel(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ManagementLockLevel other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ManagementLockLevel other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
