// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Resources.Models
{
    internal static partial class LocationTypeExtensions
    {
        public static string ToSerialString(this LocationType value) => value switch
        {
            LocationType.Region => "Region",
            LocationType.EdgeZone => "EdgeZone",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown LocationType value.")
        };

        public static LocationType ToLocationType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Region")) return LocationType.Region;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "EdgeZone")) return LocationType.EdgeZone;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown LocationType value.");
        }
    }
}
