// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Resources.Models
{
    /// <summary> Location metadata information. </summary>
    public partial class LocationMetadata
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="LocationMetadata"/>. </summary>
        internal LocationMetadata()
        {
            PairedRegions = new ChangeTrackingList<PairedRegion>();
        }

        /// <summary> Initializes a new instance of <see cref="LocationMetadata"/>. </summary>
        /// <param name="regionType"> The type of the region. </param>
        /// <param name="regionCategory"> The category of the region. </param>
        /// <param name="geography"> The geography of the location. </param>
        /// <param name="geographyGroup"> The geography group of the location. </param>
        /// <param name="longitude"> The longitude of the location. </param>
        /// <param name="latitude"> The latitude of the location. </param>
        /// <param name="physicalLocation"> The physical location of the Azure location. </param>
        /// <param name="pairedRegions"> The regions paired to this region. </param>
        /// <param name="homeLocation"> The home location of an edge zone. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal LocationMetadata(RegionType? regionType, RegionCategory? regionCategory, string geography, string geographyGroup, double? longitude, double? latitude, string physicalLocation, IReadOnlyList<PairedRegion> pairedRegions, string homeLocation, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            RegionType = regionType;
            RegionCategory = regionCategory;
            Geography = geography;
            GeographyGroup = geographyGroup;
            Longitude = longitude;
            Latitude = latitude;
            PhysicalLocation = physicalLocation;
            PairedRegions = pairedRegions;
            HomeLocation = homeLocation;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The type of the region. </summary>
        [WirePath("regionType")]
        public RegionType? RegionType { get; }
        /// <summary> The category of the region. </summary>
        [WirePath("regionCategory")]
        public RegionCategory? RegionCategory { get; }
        /// <summary> The geography of the location. </summary>
        [WirePath("geography")]
        public string Geography { get; }
        /// <summary> The geography group of the location. </summary>
        [WirePath("geographyGroup")]
        public string GeographyGroup { get; }
        /// <summary> The physical location of the Azure location. </summary>
        [WirePath("physicalLocation")]
        public string PhysicalLocation { get; }
        /// <summary> The regions paired to this region. </summary>
        [WirePath("pairedRegion")]
        public IReadOnlyList<PairedRegion> PairedRegions { get; }
        /// <summary> The home location of an edge zone. </summary>
        [WirePath("homeLocation")]
        public string HomeLocation { get; }
    }
}
