// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Resources.Models
{
    public partial class LocationMetadata : IUtf8JsonSerializable, IJsonModel<LocationMetadata>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<LocationMetadata>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<LocationMetadata>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<LocationMetadata>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(LocationMetadata)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(RegionType))
            {
                writer.WritePropertyName("regionType"u8);
                writer.WriteStringValue(RegionType.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(RegionCategory))
            {
                writer.WritePropertyName("regionCategory"u8);
                writer.WriteStringValue(RegionCategory.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(Geography))
            {
                writer.WritePropertyName("geography"u8);
                writer.WriteStringValue(Geography);
            }
            if (options.Format != "W" && Optional.IsDefined(GeographyGroup))
            {
                writer.WritePropertyName("geographyGroup"u8);
                writer.WriteStringValue(GeographyGroup);
            }
            if (options.Format != "W" && Optional.IsDefined(Longitude))
            {
                writer.WritePropertyName("longitude"u8);
                WriteLongitude(writer, options);
            }
            if (options.Format != "W" && Optional.IsDefined(Latitude))
            {
                writer.WritePropertyName("latitude"u8);
                WriteLatitude(writer, options);
            }
            if (options.Format != "W" && Optional.IsDefined(PhysicalLocation))
            {
                writer.WritePropertyName("physicalLocation"u8);
                writer.WriteStringValue(PhysicalLocation);
            }
            if (Optional.IsCollectionDefined(PairedRegions))
            {
                writer.WritePropertyName("pairedRegion"u8);
                writer.WriteStartArray();
                foreach (var item in PairedRegions)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(HomeLocation))
            {
                writer.WritePropertyName("homeLocation"u8);
                writer.WriteStringValue(HomeLocation);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        LocationMetadata IJsonModel<LocationMetadata>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<LocationMetadata>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(LocationMetadata)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeLocationMetadata(document.RootElement, options);
        }

        internal static LocationMetadata DeserializeLocationMetadata(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            RegionType? regionType = default;
            RegionCategory? regionCategory = default;
            string geography = default;
            string geographyGroup = default;
            double? longitude = default;
            double? latitude = default;
            string physicalLocation = default;
            IReadOnlyList<PairedRegion> pairedRegion = default;
            string homeLocation = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("regionType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    regionType = new RegionType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("regionCategory"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    regionCategory = new RegionCategory(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("geography"u8))
                {
                    geography = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("geographyGroup"u8))
                {
                    geographyGroup = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("longitude"u8))
                {
                    ReadLongitude(property, ref longitude);
                    continue;
                }
                if (property.NameEquals("latitude"u8))
                {
                    ReadLatitude(property, ref latitude);
                    continue;
                }
                if (property.NameEquals("physicalLocation"u8))
                {
                    physicalLocation = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("pairedRegion"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<PairedRegion> array = new List<PairedRegion>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(PairedRegion.DeserializePairedRegion(item, options));
                    }
                    pairedRegion = array;
                    continue;
                }
                if (property.NameEquals("homeLocation"u8))
                {
                    homeLocation = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new LocationMetadata(
                regionType,
                regionCategory,
                geography,
                geographyGroup,
                longitude,
                latitude,
                physicalLocation,
                pairedRegion ?? new ChangeTrackingList<PairedRegion>(),
                homeLocation,
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(RegionType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  regionType: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(RegionType))
                {
                    builder.Append("  regionType: ");
                    builder.AppendLine($"'{RegionType.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(RegionCategory), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  regionCategory: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(RegionCategory))
                {
                    builder.Append("  regionCategory: ");
                    builder.AppendLine($"'{RegionCategory.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Geography), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  geography: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Geography))
                {
                    builder.Append("  geography: ");
                    if (Geography.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Geography}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Geography}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(GeographyGroup), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  geographyGroup: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(GeographyGroup))
                {
                    builder.Append("  geographyGroup: ");
                    if (GeographyGroup.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{GeographyGroup}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{GeographyGroup}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Longitude), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  longitude: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Longitude))
                {
                    builder.Append("  longitude: ");
                    builder.AppendLine($"'{Longitude.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Latitude), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  latitude: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Latitude))
                {
                    builder.Append("  latitude: ");
                    builder.AppendLine($"'{Latitude.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PhysicalLocation), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  physicalLocation: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(PhysicalLocation))
                {
                    builder.Append("  physicalLocation: ");
                    if (PhysicalLocation.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{PhysicalLocation}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{PhysicalLocation}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PairedRegions), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  pairedRegion: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(PairedRegions))
                {
                    if (PairedRegions.Any())
                    {
                        builder.Append("  pairedRegion: ");
                        builder.AppendLine("[");
                        foreach (var item in PairedRegions)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  pairedRegion: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(HomeLocation), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  homeLocation: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(HomeLocation))
                {
                    builder.Append("  homeLocation: ");
                    if (HomeLocation.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{HomeLocation}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{HomeLocation}'");
                    }
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<LocationMetadata>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<LocationMetadata>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(LocationMetadata)} does not support writing '{options.Format}' format.");
            }
        }

        LocationMetadata IPersistableModel<LocationMetadata>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<LocationMetadata>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeLocationMetadata(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(LocationMetadata)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<LocationMetadata>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
