// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.Resources.Models
{
    /// <summary> Resource extended location. </summary>
    [PropertyReferenceType]
    public partial class ExtendedLocation
    {
        /// <summary> Initializes a new instance of <see cref="ExtendedLocation"/>. </summary>
        [InitializationConstructor]
        public ExtendedLocation()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ExtendedLocation"/>. </summary>
        /// <param name="extendedLocationType"> The extended location type. </param>
        /// <param name="name"> The extended location name. </param>
        [SerializationConstructor]
        internal ExtendedLocation(ExtendedLocationType? extendedLocationType, string name)
        {
            ExtendedLocationType = extendedLocationType;
            Name = name;
        }

        /// <summary> The extended location type. </summary>
        [WirePath("type")]
        public ExtendedLocationType? ExtendedLocationType { get; set; }
        /// <summary> The extended location name. </summary>
        [WirePath("name")]
        public string Name { get; set; }
    }
}
