// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Resources.Models
{
    /// <summary> The data type of the parameter. </summary>
    public readonly partial struct ArmPolicyParameterType : IEquatable<ArmPolicyParameterType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ArmPolicyParameterType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ArmPolicyParameterType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StringValue = "String";
        private const string ArrayValue = "Array";
        private const string ObjectValue = "Object";
        private const string BooleanValue = "Boolean";
        private const string IntegerValue = "Integer";
        private const string FloatValue = "Float";
        private const string DateTimeValue = "DateTime";

        /// <summary> String. </summary>
        public static ArmPolicyParameterType String { get; } = new ArmPolicyParameterType(StringValue);
        /// <summary> Array. </summary>
        public static ArmPolicyParameterType Array { get; } = new ArmPolicyParameterType(ArrayValue);
        /// <summary> Object. </summary>
        public static ArmPolicyParameterType Object { get; } = new ArmPolicyParameterType(ObjectValue);
        /// <summary> Boolean. </summary>
        public static ArmPolicyParameterType Boolean { get; } = new ArmPolicyParameterType(BooleanValue);
        /// <summary> Integer. </summary>
        public static ArmPolicyParameterType Integer { get; } = new ArmPolicyParameterType(IntegerValue);
        /// <summary> Float. </summary>
        public static ArmPolicyParameterType Float { get; } = new ArmPolicyParameterType(FloatValue);
        /// <summary> DateTime. </summary>
        public static ArmPolicyParameterType DateTime { get; } = new ArmPolicyParameterType(DateTimeValue);
        /// <summary> Determines if two <see cref="ArmPolicyParameterType"/> values are the same. </summary>
        public static bool operator ==(ArmPolicyParameterType left, ArmPolicyParameterType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ArmPolicyParameterType"/> values are not the same. </summary>
        public static bool operator !=(ArmPolicyParameterType left, ArmPolicyParameterType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ArmPolicyParameterType"/>. </summary>
        public static implicit operator ArmPolicyParameterType(string value) => new ArmPolicyParameterType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ArmPolicyParameterType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ArmPolicyParameterType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
