// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Resources.Models
{
    /// <summary> The ApiProfile. </summary>
    public partial class ApiProfile
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ApiProfile"/>. </summary>
        internal ApiProfile()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ApiProfile"/>. </summary>
        /// <param name="profileVersion"> The profile version. </param>
        /// <param name="apiVersion"> The API version. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ApiProfile(string profileVersion, string apiVersion, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ProfileVersion = profileVersion;
            ApiVersion = apiVersion;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The profile version. </summary>
        [WirePath("profileVersion")]
        public string ProfileVersion { get; }
        /// <summary> The API version. </summary>
        [WirePath("apiVersion")]
        public string ApiVersion { get; }
    }
}
