// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Resources
{
    internal class TagResourceOperationSource : IOperationSource<TagResource>
    {
        private readonly ArmClient _client;

        internal TagResourceOperationSource(ArmClient client)
        {
            _client = client;
        }

        TagResource IOperationSource<TagResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = TagResourceData.DeserializeTagResourceData(document.RootElement);
            return new TagResource(_client, data);
        }

        async ValueTask<TagResource> IOperationSource<TagResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = TagResourceData.DeserializeTagResourceData(document.RootElement);
            return new TagResource(_client, data);
        }
    }
}
