// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.Resources
{
    /// <summary>
    /// A class representing the GenericResource data model.
    /// Resource information.
    /// </summary>
    public partial class GenericResourceData : TrackedResourceExtendedData
    {
        /// <summary> Initializes a new instance of <see cref="GenericResourceData"/>. </summary>
        /// <param name="location"> The location. </param>
        public GenericResourceData(AzureLocation location) : base(location)
        {
        }

        /// <summary> Initializes a new instance of <see cref="GenericResourceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="extendedLocation"> Resource extended location. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="plan"> The plan of the resource. </param>
        /// <param name="properties"> The resource properties. </param>
        /// <param name="kind"> The kind of the resource. </param>
        /// <param name="managedBy"> ID of the resource that manages this resource. </param>
        /// <param name="sku"> The SKU of the resource. </param>
        /// <param name="identity"> The identity of the resource. </param>
        /// <param name="createdOn"> The created time of the resource. This is only present if requested via the $expand query parameter. </param>
        /// <param name="changedOn"> The changed time of the resource. This is only present if requested via the $expand query parameter. </param>
        /// <param name="provisioningState"> The provisioning state of the resource. This is only present if requested via the $expand query parameter. </param>
        internal GenericResourceData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, ExtendedLocation extendedLocation, IDictionary<string, BinaryData> serializedAdditionalRawData, ArmPlan plan, BinaryData properties, string kind, string managedBy, ResourcesSku sku, ManagedServiceIdentity identity, DateTimeOffset? createdOn, DateTimeOffset? changedOn, string provisioningState) : base(id, name, resourceType, systemData, tags, location, extendedLocation, serializedAdditionalRawData)
        {
            Plan = plan;
            Properties = properties;
            Kind = kind;
            ManagedBy = managedBy;
            Sku = sku;
            Identity = identity;
            CreatedOn = createdOn;
            ChangedOn = changedOn;
            ProvisioningState = provisioningState;
        }

        /// <summary> Initializes a new instance of <see cref="GenericResourceData"/> for deserialization. </summary>
        internal GenericResourceData()
        {
        }

        /// <summary> The plan of the resource. </summary>
        [WirePath("plan")]
        public ArmPlan Plan { get; set; }
        /// <summary>
        /// The resource properties.
        /// <para>
        /// To assign an object to this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        [WirePath("properties")]
        public BinaryData Properties { get; set; }
        /// <summary> The kind of the resource. </summary>
        [WirePath("kind")]
        public string Kind { get; set; }
        /// <summary> ID of the resource that manages this resource. </summary>
        [WirePath("managedBy")]
        public string ManagedBy { get; set; }
        /// <summary> The SKU of the resource. </summary>
        [WirePath("sku")]
        public ResourcesSku Sku { get; set; }
        /// <summary> The identity of the resource. </summary>
        [WirePath("identity")]
        public ManagedServiceIdentity Identity { get; set; }
        /// <summary> The created time of the resource. This is only present if requested via the $expand query parameter. </summary>
        [WirePath("createdTime")]
        public DateTimeOffset? CreatedOn { get; }
        /// <summary> The changed time of the resource. This is only present if requested via the $expand query parameter. </summary>
        [WirePath("changedTime")]
        public DateTimeOffset? ChangedOn { get; }
        /// <summary> The provisioning state of the resource. This is only present if requested via the $expand query parameter. </summary>
        [WirePath("provisioningState")]
        public string ProvisioningState { get; }
    }
}
