// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.Resources
{
    public partial class DataPolicyManifestData : IUtf8JsonSerializable, IJsonModel<DataPolicyManifestData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<DataPolicyManifestData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<DataPolicyManifestData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DataPolicyManifestData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DataPolicyManifestData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (Optional.IsCollectionDefined(Namespaces))
            {
                writer.WritePropertyName("namespaces"u8);
                writer.WriteStartArray();
                foreach (var item in Namespaces)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(PolicyMode))
            {
                writer.WritePropertyName("policyMode"u8);
                writer.WriteStringValue(PolicyMode);
            }
            if (Optional.IsDefined(IsBuiltInOnly))
            {
                writer.WritePropertyName("isBuiltInOnly"u8);
                writer.WriteBooleanValue(IsBuiltInOnly.Value);
            }
            if (Optional.IsCollectionDefined(ResourceTypeAliases))
            {
                writer.WritePropertyName("resourceTypeAliases"u8);
                writer.WriteStartArray();
                foreach (var item in ResourceTypeAliases)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Effects))
            {
                writer.WritePropertyName("effects"u8);
                writer.WriteStartArray();
                foreach (var item in Effects)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(FieldValues))
            {
                writer.WritePropertyName("fieldValues"u8);
                writer.WriteStartArray();
                foreach (var item in FieldValues)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            writer.WritePropertyName("resourceFunctions"u8);
            writer.WriteStartObject();
            if (Optional.IsCollectionDefined(Standard))
            {
                writer.WritePropertyName("standard"u8);
                writer.WriteStartArray();
                foreach (var item in Standard)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(CustomDefinitions))
            {
                writer.WritePropertyName("custom"u8);
                writer.WriteStartArray();
                foreach (var item in CustomDefinitions)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            writer.WriteEndObject();
            writer.WriteEndObject();
        }

        DataPolicyManifestData IJsonModel<DataPolicyManifestData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DataPolicyManifestData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DataPolicyManifestData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeDataPolicyManifestData(document.RootElement, options);
        }

        internal static DataPolicyManifestData DeserializeDataPolicyManifestData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            IReadOnlyList<string> namespaces = default;
            string policyMode = default;
            bool? isBuiltInOnly = default;
            IReadOnlyList<ResourceTypeAliases> resourceTypeAliases = default;
            IReadOnlyList<DataPolicyManifestEffect> effects = default;
            IReadOnlyList<string> fieldValues = default;
            IReadOnlyList<string> standard = default;
            IReadOnlyList<DataManifestCustomResourceFunctionDefinition> custom = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("namespaces"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<string> array = new List<string>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(item.GetString());
                            }
                            namespaces = array;
                            continue;
                        }
                        if (property0.NameEquals("policyMode"u8))
                        {
                            policyMode = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("isBuiltInOnly"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            isBuiltInOnly = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("resourceTypeAliases"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<ResourceTypeAliases> array = new List<ResourceTypeAliases>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(Models.ResourceTypeAliases.DeserializeResourceTypeAliases(item, options));
                            }
                            resourceTypeAliases = array;
                            continue;
                        }
                        if (property0.NameEquals("effects"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<DataPolicyManifestEffect> array = new List<DataPolicyManifestEffect>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(DataPolicyManifestEffect.DeserializeDataPolicyManifestEffect(item, options));
                            }
                            effects = array;
                            continue;
                        }
                        if (property0.NameEquals("fieldValues"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<string> array = new List<string>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(item.GetString());
                            }
                            fieldValues = array;
                            continue;
                        }
                        if (property0.NameEquals("resourceFunctions"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                property0.ThrowNonNullablePropertyIsNull();
                                continue;
                            }
                            foreach (var property1 in property0.Value.EnumerateObject())
                            {
                                if (property1.NameEquals("standard"u8))
                                {
                                    if (property1.Value.ValueKind == JsonValueKind.Null)
                                    {
                                        continue;
                                    }
                                    List<string> array = new List<string>();
                                    foreach (var item in property1.Value.EnumerateArray())
                                    {
                                        array.Add(item.GetString());
                                    }
                                    standard = array;
                                    continue;
                                }
                                if (property1.NameEquals("custom"u8))
                                {
                                    if (property1.Value.ValueKind == JsonValueKind.Null)
                                    {
                                        continue;
                                    }
                                    List<DataManifestCustomResourceFunctionDefinition> array = new List<DataManifestCustomResourceFunctionDefinition>();
                                    foreach (var item in property1.Value.EnumerateArray())
                                    {
                                        array.Add(DataManifestCustomResourceFunctionDefinition.DeserializeDataManifestCustomResourceFunctionDefinition(item, options));
                                    }
                                    custom = array;
                                    continue;
                                }
                            }
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new DataPolicyManifestData(
                id,
                name,
                type,
                systemData,
                namespaces ?? new ChangeTrackingList<string>(),
                policyMode,
                isBuiltInOnly,
                resourceTypeAliases ?? new ChangeTrackingList<ResourceTypeAliases>(),
                effects ?? new ChangeTrackingList<DataPolicyManifestEffect>(),
                fieldValues ?? new ChangeTrackingList<string>(),
                standard ?? new ChangeTrackingList<string>(),
                custom ?? new ChangeTrackingList<DataManifestCustomResourceFunctionDefinition>(),
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Name), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  name: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Name))
                {
                    builder.Append("  name: ");
                    if (Name.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Name}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Name}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Id), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  id: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Id))
                {
                    builder.Append("  id: ");
                    builder.AppendLine($"'{Id.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SystemData), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  systemData: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SystemData))
                {
                    builder.Append("  systemData: ");
                    builder.AppendLine($"'{SystemData.ToString()}'");
                }
            }

            builder.Append("  properties:");
            builder.AppendLine(" {");
            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Namespaces), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    namespaces: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(Namespaces))
                {
                    if (Namespaces.Any())
                    {
                        builder.Append("    namespaces: ");
                        builder.AppendLine("[");
                        foreach (var item in Namespaces)
                        {
                            if (item == null)
                            {
                                builder.Append("null");
                                continue;
                            }
                            if (item.Contains(Environment.NewLine))
                            {
                                builder.AppendLine("      '''");
                                builder.AppendLine($"{item}'''");
                            }
                            else
                            {
                                builder.AppendLine($"      '{item}'");
                            }
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PolicyMode), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    policyMode: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(PolicyMode))
                {
                    builder.Append("    policyMode: ");
                    if (PolicyMode.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{PolicyMode}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{PolicyMode}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IsBuiltInOnly), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    isBuiltInOnly: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IsBuiltInOnly))
                {
                    builder.Append("    isBuiltInOnly: ");
                    var boolValue = IsBuiltInOnly.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ResourceTypeAliases), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    resourceTypeAliases: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(ResourceTypeAliases))
                {
                    if (ResourceTypeAliases.Any())
                    {
                        builder.Append("    resourceTypeAliases: ");
                        builder.AppendLine("[");
                        foreach (var item in ResourceTypeAliases)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 6, true, "    resourceTypeAliases: ");
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Effects), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    effects: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(Effects))
                {
                    if (Effects.Any())
                    {
                        builder.Append("    effects: ");
                        builder.AppendLine("[");
                        foreach (var item in Effects)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 6, true, "    effects: ");
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(FieldValues), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    fieldValues: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(FieldValues))
                {
                    if (FieldValues.Any())
                    {
                        builder.Append("    fieldValues: ");
                        builder.AppendLine("[");
                        foreach (var item in FieldValues)
                        {
                            if (item == null)
                            {
                                builder.Append("null");
                                continue;
                            }
                            if (item.Contains(Environment.NewLine))
                            {
                                builder.AppendLine("      '''");
                                builder.AppendLine($"{item}'''");
                            }
                            else
                            {
                                builder.AppendLine($"      '{item}'");
                            }
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            builder.Append("    resourceFunctions:");
            builder.AppendLine(" {");
            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Standard), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("      standard: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(Standard))
                {
                    if (Standard.Any())
                    {
                        builder.Append("      standard: ");
                        builder.AppendLine("[");
                        foreach (var item in Standard)
                        {
                            if (item == null)
                            {
                                builder.Append("null");
                                continue;
                            }
                            if (item.Contains(Environment.NewLine))
                            {
                                builder.AppendLine("        '''");
                                builder.AppendLine($"{item}'''");
                            }
                            else
                            {
                                builder.AppendLine($"        '{item}'");
                            }
                        }
                        builder.AppendLine("      ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CustomDefinitions), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("      custom: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(CustomDefinitions))
                {
                    if (CustomDefinitions.Any())
                    {
                        builder.Append("      custom: ");
                        builder.AppendLine("[");
                        foreach (var item in CustomDefinitions)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 8, true, "      custom: ");
                        }
                        builder.AppendLine("      ]");
                    }
                }
            }

            builder.AppendLine("    }");
            builder.AppendLine("  }");
            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<DataPolicyManifestData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DataPolicyManifestData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(DataPolicyManifestData)} does not support writing '{options.Format}' format.");
            }
        }

        DataPolicyManifestData IPersistableModel<DataPolicyManifestData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DataPolicyManifestData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeDataPolicyManifestData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(DataPolicyManifestData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<DataPolicyManifestData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
