// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.Resources
{
    /// <summary> A class representing collection of Provider and their operations over its parent. </summary>
    [CodeGenSuppress("GetAllAsGenericResources", typeof(string), typeof(string), typeof(int?), typeof(CancellationToken))]
    [CodeGenSuppress("GetAllAsGenericResourcesAsync", typeof(string), typeof(string), typeof(int?), typeof(CancellationToken))]
    public partial class ResourceProviderCollection : ArmCollection, IEnumerable<ResourceProviderResource>, IAsyncEnumerable<ResourceProviderResource>
    {
        /// <summary> Initializes a new instance of the <see cref="ResourceProviderCollection"/> class. </summary>
        /// <param name="parent"> The resource representing the parent resource. </param>
        internal ResourceProviderCollection(ArmResource parent) : this(parent.Client, parent.Id)
        {
        }

        internal ResourceProviderCollection(ArmClient client, ResourceIdentifier id)
            : base(client, id)
        {
            _resourceProviderProvidersClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Resources", ResourceProviderResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ResourceProviderResource.ResourceType, out string providerApiVersion);
            _resourceProviderProvidersRestClient = new ProvidersRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, providerApiVersion);
#if DEBUG
            ValidateResourceId(Id);
#endif
        }

        [ForwardsClientCalls(true)]
        internal virtual string GetApiVersion(ResourceType resourceType, CancellationToken cancellationToken = default)
        {
            string version;
            Dictionary<string, string> resourceVersions;
            if (!Client.ApiVersionOverrides.TryGetValue(resourceType, out version))
            {
                if (!Client.ResourceApiVersionCache.TryGetValue(resourceType.Namespace, out resourceVersions))
                {
                    resourceVersions = LoadResourceVersionsFromApi(resourceType.Namespace, cancellationToken);
                    Client.ResourceApiVersionCache.TryAdd(resourceType.Namespace, resourceVersions);
                }
                if (!resourceVersions.TryGetValue(resourceType.Type, out version))
                {
                    throw new InvalidOperationException($"Invalid resource type {resourceType}");
                }
            }
            return version;
        }

        [ForwardsClientCalls(true)]
        internal virtual async ValueTask<string> GetApiVersionAsync(ResourceType resourceType, CancellationToken cancellationToken = default)
        {
            string version;
            Dictionary<string, string> resourceVersions;
            if (!Client.ApiVersionOverrides.TryGetValue(resourceType, out version))
            {
                if (!Client.ResourceApiVersionCache.TryGetValue(resourceType.Namespace, out resourceVersions))
                {
                    resourceVersions = await LoadResourceVersionsFromApiAsync(resourceType.Namespace, cancellationToken).ConfigureAwait(false);
                    Client.ResourceApiVersionCache.TryAdd(resourceType.Namespace, resourceVersions);
                }
                if (!resourceVersions.TryGetValue(resourceType.Type, out version))
                {
                    throw new InvalidOperationException($"Invalid resource type {resourceType}");
                }
            }
            return version;
        }

        private Dictionary<string, string> LoadResourceVersionsFromApi(string resourceNamespace, CancellationToken cancellationToken = default)
        {
            ResourceProviderResource results = Get(resourceNamespace, cancellationToken: cancellationToken);
            return GetVersionsFromResult(results);
        }

        private async Task<Dictionary<string, string>> LoadResourceVersionsFromApiAsync(string resourceNamespace, CancellationToken cancellationToken = default)
        {
            ResourceProviderResource results = await GetAsync(resourceNamespace, cancellationToken: cancellationToken).ConfigureAwait(false);
            return GetVersionsFromResult(results);
        }

        private static Dictionary<string, string> GetVersionsFromResult(ResourceProviderResource results)
        {
            Dictionary<string, string> resourceVersions = new Dictionary<string, string>(StringComparer.OrdinalIgnoreCase);
            foreach (var type in results.Data.ResourceTypes)
            {
                if (type.ApiVersions.Count == 0)
                    continue;
                resourceVersions[type.ResourceType] = type.ApiVersions[0];
            }
            return resourceVersions;
        }

        /// <summary>
        /// Gets all resource providers for a subscription.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Providers_List</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="top"> [This parameter is no longer supported.] The number of results to return. </param>
        /// <param name="expand"> The properties to include in the results. For example, use &amp;$expand=metadata in the query string to retrieve resource provider metadata. To include property aliases in response, use $expand=resourceTypes/aliases. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="ResourceProviderResource" /> that may take multiple service requests to iterate over. </returns>
        [System.ComponentModel.EditorBrowsableAttribute(System.ComponentModel.EditorBrowsableState.Never)]
        [System.ObsoleteAttribute("This method is obsolete as the `top` parameter is not supported by service and will be removed in a future release.", false)]
        public virtual AsyncPageable<ResourceProviderResource> GetAllAsync(int? top, string expand, CancellationToken cancellationToken = default)
        {
            return GetAllAsync(expand, cancellationToken);
        }

        /// <summary>
        /// Gets all resource providers for a subscription.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Providers_List</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="top"> [This parameter is no longer supported.] The number of results to return. </param>
        /// <param name="expand"> The properties to include in the results. For example, use &amp;$expand=metadata in the query string to retrieve resource provider metadata. To include property aliases in response, use $expand=resourceTypes/aliases. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="ResourceProviderResource" /> that may take multiple service requests to iterate over. </returns>
        [System.ComponentModel.EditorBrowsableAttribute(System.ComponentModel.EditorBrowsableState.Never)]
        [System.ObsoleteAttribute("This method is obsolete as the `top` parameter is not supported by service and will be removed in a future release.", false)]
        public virtual Pageable<ResourceProviderResource> GetAll(int? top, string expand, CancellationToken cancellationToken = default)
        {
            return GetAll(expand, cancellationToken);
        }
    }
}
