// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ManagementGroups.Models
{
    /// <summary> The type of child resource. </summary>
    public readonly partial struct ManagementGroupChildType : IEquatable<ManagementGroupChildType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ManagementGroupChildType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ManagementGroupChildType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MicrosoftManagementManagementGroupsValue = "Microsoft.Management/managementGroups";
        private const string SubscriptionsValue = "/subscriptions";

        /// <summary> Microsoft.Management/managementGroups. </summary>
        public static ManagementGroupChildType MicrosoftManagementManagementGroups { get; } = new ManagementGroupChildType(MicrosoftManagementManagementGroupsValue);
        /// <summary> /subscriptions. </summary>
        public static ManagementGroupChildType Subscriptions { get; } = new ManagementGroupChildType(SubscriptionsValue);
        /// <summary> Determines if two <see cref="ManagementGroupChildType"/> values are the same. </summary>
        public static bool operator ==(ManagementGroupChildType left, ManagementGroupChildType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ManagementGroupChildType"/> values are not the same. </summary>
        public static bool operator !=(ManagementGroupChildType left, ManagementGroupChildType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ManagementGroupChildType"/>. </summary>
        public static implicit operator ManagementGroupChildType(string value) => new ManagementGroupChildType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ManagementGroupChildType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ManagementGroupChildType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
