// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ManagementGroups.Models
{
    /// <summary> The EntityViewOption. </summary>
    public readonly partial struct EntityViewOption : IEquatable<EntityViewOption>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EntityViewOption"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EntityViewOption(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string FullHierarchyValue = "FullHierarchy";
        private const string GroupsOnlyValue = "GroupsOnly";
        private const string SubscriptionsOnlyValue = "SubscriptionsOnly";
        private const string AuditValue = "Audit";

        /// <summary> FullHierarchy. </summary>
        public static EntityViewOption FullHierarchy { get; } = new EntityViewOption(FullHierarchyValue);
        /// <summary> GroupsOnly. </summary>
        public static EntityViewOption GroupsOnly { get; } = new EntityViewOption(GroupsOnlyValue);
        /// <summary> SubscriptionsOnly. </summary>
        public static EntityViewOption SubscriptionsOnly { get; } = new EntityViewOption(SubscriptionsOnlyValue);
        /// <summary> Audit. </summary>
        public static EntityViewOption Audit { get; } = new EntityViewOption(AuditValue);
        /// <summary> Determines if two <see cref="EntityViewOption"/> values are the same. </summary>
        public static bool operator ==(EntityViewOption left, EntityViewOption right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EntityViewOption"/> values are not the same. </summary>
        public static bool operator !=(EntityViewOption left, EntityViewOption right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EntityViewOption"/>. </summary>
        public static implicit operator EntityViewOption(string value) => new EntityViewOption(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EntityViewOption other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EntityViewOption other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
