// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ManagementGroups.Models
{
    /// <summary> The EntitySearchOption. </summary>
    public readonly partial struct EntitySearchOption : IEquatable<EntitySearchOption>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EntitySearchOption"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EntitySearchOption(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AllowedParentsValue = "AllowedParents";
        private const string AllowedChildrenValue = "AllowedChildren";
        private const string ParentAndFirstLevelChildrenValue = "ParentAndFirstLevelChildren";
        private const string ParentOnlyValue = "ParentOnly";
        private const string ChildrenOnlyValue = "ChildrenOnly";

        /// <summary> AllowedParents. </summary>
        public static EntitySearchOption AllowedParents { get; } = new EntitySearchOption(AllowedParentsValue);
        /// <summary> AllowedChildren. </summary>
        public static EntitySearchOption AllowedChildren { get; } = new EntitySearchOption(AllowedChildrenValue);
        /// <summary> ParentAndFirstLevelChildren. </summary>
        public static EntitySearchOption ParentAndFirstLevelChildren { get; } = new EntitySearchOption(ParentAndFirstLevelChildrenValue);
        /// <summary> ParentOnly. </summary>
        public static EntitySearchOption ParentOnly { get; } = new EntitySearchOption(ParentOnlyValue);
        /// <summary> ChildrenOnly. </summary>
        public static EntitySearchOption ChildrenOnly { get; } = new EntitySearchOption(ChildrenOnlyValue);
        /// <summary> Determines if two <see cref="EntitySearchOption"/> values are the same. </summary>
        public static bool operator ==(EntitySearchOption left, EntitySearchOption right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EntitySearchOption"/> values are not the same. </summary>
        public static bool operator !=(EntitySearchOption left, EntitySearchOption right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EntitySearchOption"/>. </summary>
        public static implicit operator EntitySearchOption(string value) => new EntitySearchOption(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EntitySearchOption other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EntitySearchOption other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
