// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.ManagementGroups.Models
{
    internal static partial class EntityPermissionExtensions
    {
        public static string ToSerialString(this EntityPermission value) => value switch
        {
            EntityPermission.NoAccess => "noaccess",
            EntityPermission.View => "view",
            EntityPermission.Edit => "edit",
            EntityPermission.Delete => "delete",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown EntityPermission value.")
        };

        public static EntityPermission ToEntityPermission(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "noaccess")) return EntityPermission.NoAccess;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "view")) return EntityPermission.View;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "edit")) return EntityPermission.Edit;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "delete")) return EntityPermission.Delete;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown EntityPermission value.");
        }
    }
}
