// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.ManagementGroups.Models
{
    public partial class EntityData : IUtf8JsonSerializable, IJsonModel<EntityData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<EntityData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<EntityData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<EntityData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(EntityData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(TenantId))
            {
                if (TenantId != null)
                {
                    writer.WritePropertyName("tenantId"u8);
                    writer.WriteStringValue(TenantId.Value);
                }
                else
                {
                    writer.WriteNull("tenantId");
                }
            }
            if (Optional.IsDefined(DisplayName))
            {
                if (DisplayName != null)
                {
                    writer.WritePropertyName("displayName"u8);
                    writer.WriteStringValue(DisplayName);
                }
                else
                {
                    writer.WriteNull("displayName");
                }
            }
            if (Optional.IsDefined(Parent))
            {
                writer.WritePropertyName("parent"u8);
                JsonSerializer.Serialize(writer, Parent);
            }
            if (Optional.IsDefined(Permissions))
            {
                if (Permissions != null)
                {
                    writer.WritePropertyName("permissions"u8);
                    writer.WriteStringValue(Permissions.Value.ToSerialString());
                }
                else
                {
                    writer.WriteNull("permissions");
                }
            }
            if (Optional.IsDefined(InheritedPermissions))
            {
                if (InheritedPermissions != null)
                {
                    writer.WritePropertyName("inheritedPermissions"u8);
                    writer.WriteStringValue(InheritedPermissions.Value.ToSerialString());
                }
                else
                {
                    writer.WriteNull("inheritedPermissions");
                }
            }
            if (Optional.IsDefined(NumberOfDescendants))
            {
                if (NumberOfDescendants != null)
                {
                    writer.WritePropertyName("numberOfDescendants"u8);
                    writer.WriteNumberValue(NumberOfDescendants.Value);
                }
                else
                {
                    writer.WriteNull("numberOfDescendants");
                }
            }
            if (Optional.IsDefined(NumberOfChildren))
            {
                if (NumberOfChildren != null)
                {
                    writer.WritePropertyName("numberOfChildren"u8);
                    writer.WriteNumberValue(NumberOfChildren.Value);
                }
                else
                {
                    writer.WriteNull("numberOfChildren");
                }
            }
            if (Optional.IsDefined(NumberOfChildGroups))
            {
                if (NumberOfChildGroups != null)
                {
                    writer.WritePropertyName("numberOfChildGroups"u8);
                    writer.WriteNumberValue(NumberOfChildGroups.Value);
                }
                else
                {
                    writer.WriteNull("numberOfChildGroups");
                }
            }
            if (Optional.IsCollectionDefined(ParentDisplayNameChain))
            {
                if (ParentDisplayNameChain != null)
                {
                    writer.WritePropertyName("parentDisplayNameChain"u8);
                    writer.WriteStartArray();
                    foreach (var item in ParentDisplayNameChain)
                    {
                        writer.WriteStringValue(item);
                    }
                    writer.WriteEndArray();
                }
                else
                {
                    writer.WriteNull("parentDisplayNameChain");
                }
            }
            if (Optional.IsCollectionDefined(ParentNameChain))
            {
                if (ParentNameChain != null)
                {
                    writer.WritePropertyName("parentNameChain"u8);
                    writer.WriteStartArray();
                    foreach (var item in ParentNameChain)
                    {
                        writer.WriteStringValue(item);
                    }
                    writer.WriteEndArray();
                }
                else
                {
                    writer.WriteNull("parentNameChain");
                }
            }
            writer.WriteEndObject();
        }

        EntityData IJsonModel<EntityData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<EntityData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(EntityData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeEntityData(document.RootElement, options);
        }

        internal static EntityData DeserializeEntityData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            Guid? tenantId = default;
            string displayName = default;
            SubResource parent = default;
            EntityPermission? permissions = default;
            EntityPermission? inheritedPermissions = default;
            int? numberOfDescendants = default;
            int? numberOfChildren = default;
            int? numberOfChildGroups = default;
            IReadOnlyList<string> parentDisplayNameChain = default;
            IReadOnlyList<string> parentNameChain = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("tenantId"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                tenantId = null;
                                continue;
                            }
                            tenantId = property0.Value.GetGuid();
                            continue;
                        }
                        if (property0.NameEquals("displayName"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                displayName = null;
                                continue;
                            }
                            displayName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("parent"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            parent = JsonSerializer.Deserialize<SubResource>(property0.Value.GetRawText());
                            continue;
                        }
                        if (property0.NameEquals("permissions"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                permissions = null;
                                continue;
                            }
                            permissions = property0.Value.GetString().ToEntityPermission();
                            continue;
                        }
                        if (property0.NameEquals("inheritedPermissions"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                inheritedPermissions = null;
                                continue;
                            }
                            inheritedPermissions = property0.Value.GetString().ToEntityPermission();
                            continue;
                        }
                        if (property0.NameEquals("numberOfDescendants"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                numberOfDescendants = null;
                                continue;
                            }
                            numberOfDescendants = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("numberOfChildren"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                numberOfChildren = null;
                                continue;
                            }
                            numberOfChildren = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("numberOfChildGroups"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                numberOfChildGroups = null;
                                continue;
                            }
                            numberOfChildGroups = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("parentDisplayNameChain"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                parentDisplayNameChain = null;
                                continue;
                            }
                            List<string> array = new List<string>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(item.GetString());
                            }
                            parentDisplayNameChain = array;
                            continue;
                        }
                        if (property0.NameEquals("parentNameChain"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                parentNameChain = null;
                                continue;
                            }
                            List<string> array = new List<string>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(item.GetString());
                            }
                            parentNameChain = array;
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new EntityData(
                id,
                name,
                type,
                systemData,
                tenantId,
                displayName,
                parent,
                permissions,
                inheritedPermissions,
                numberOfDescendants,
                numberOfChildren,
                numberOfChildGroups,
                parentDisplayNameChain ?? new ChangeTrackingList<string>(),
                parentNameChain ?? new ChangeTrackingList<string>(),
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Name), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  name: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Name))
                {
                    builder.Append("  name: ");
                    if (Name.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Name}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Name}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Id), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  id: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Id))
                {
                    builder.Append("  id: ");
                    builder.AppendLine($"'{Id.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SystemData), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  systemData: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SystemData))
                {
                    builder.Append("  systemData: ");
                    builder.AppendLine($"'{SystemData.ToString()}'");
                }
            }

            builder.Append("  properties:");
            builder.AppendLine(" {");
            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(TenantId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    tenantId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(TenantId))
                {
                    builder.Append("    tenantId: ");
                    builder.AppendLine($"'{TenantId.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DisplayName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    displayName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DisplayName))
                {
                    builder.Append("    displayName: ");
                    if (DisplayName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{DisplayName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{DisplayName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue("ParentId", out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    parent: ");
                builder.AppendLine("{");
                builder.AppendLine("      parent: {");
                builder.Append("        id: ");
                builder.AppendLine(propertyOverride);
                builder.AppendLine("      }");
                builder.AppendLine("    }");
            }
            else
            {
                if (Optional.IsDefined(Parent))
                {
                    builder.Append("    parent: ");
                    BicepSerializationHelpers.AppendChildObject(builder, Parent, options, 4, false, "    parent: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Permissions), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    permissions: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Permissions))
                {
                    builder.Append("    permissions: ");
                    builder.AppendLine($"'{Permissions.Value.ToSerialString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(InheritedPermissions), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    inheritedPermissions: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(InheritedPermissions))
                {
                    builder.Append("    inheritedPermissions: ");
                    builder.AppendLine($"'{InheritedPermissions.Value.ToSerialString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(NumberOfDescendants), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    numberOfDescendants: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(NumberOfDescendants))
                {
                    builder.Append("    numberOfDescendants: ");
                    builder.AppendLine($"{NumberOfDescendants.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(NumberOfChildren), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    numberOfChildren: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(NumberOfChildren))
                {
                    builder.Append("    numberOfChildren: ");
                    builder.AppendLine($"{NumberOfChildren.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(NumberOfChildGroups), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    numberOfChildGroups: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(NumberOfChildGroups))
                {
                    builder.Append("    numberOfChildGroups: ");
                    builder.AppendLine($"{NumberOfChildGroups.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ParentDisplayNameChain), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    parentDisplayNameChain: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(ParentDisplayNameChain))
                {
                    if (ParentDisplayNameChain.Any())
                    {
                        builder.Append("    parentDisplayNameChain: ");
                        builder.AppendLine("[");
                        foreach (var item in ParentDisplayNameChain)
                        {
                            if (item == null)
                            {
                                builder.Append("null");
                                continue;
                            }
                            if (item.Contains(Environment.NewLine))
                            {
                                builder.AppendLine("      '''");
                                builder.AppendLine($"{item}'''");
                            }
                            else
                            {
                                builder.AppendLine($"      '{item}'");
                            }
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ParentNameChain), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    parentNameChain: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(ParentNameChain))
                {
                    if (ParentNameChain.Any())
                    {
                        builder.Append("    parentNameChain: ");
                        builder.AppendLine("[");
                        foreach (var item in ParentNameChain)
                        {
                            if (item == null)
                            {
                                builder.Append("null");
                                continue;
                            }
                            if (item.Contains(Environment.NewLine))
                            {
                                builder.AppendLine("      '''");
                                builder.AppendLine($"{item}'''");
                            }
                            else
                            {
                                builder.AppendLine($"      '{item}'");
                            }
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            builder.AppendLine("  }");
            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<EntityData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<EntityData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(EntityData)} does not support writing '{options.Format}' format.");
            }
        }

        EntityData IPersistableModel<EntityData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<EntityData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeEntityData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(EntityData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<EntityData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
