// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.ManagementGroups.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.ManagementGroups
{
    /// <summary>
    /// A class representing the ManagementGroupSubscription data model.
    /// The details of subscription under management group.
    /// </summary>
    public partial class ManagementGroupSubscriptionData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ManagementGroupSubscriptionData"/>. </summary>
        internal ManagementGroupSubscriptionData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ManagementGroupSubscriptionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tenant"> The AAD Tenant ID associated with the subscription. For example, 00000000-0000-0000-0000-000000000000. </param>
        /// <param name="displayName"> The friendly name of the subscription. </param>
        /// <param name="parent"> The ID of the parent management group. </param>
        /// <param name="state"> The state of the subscription. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ManagementGroupSubscriptionData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string tenant, string displayName, DescendantParentGroupInfo parent, string state, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            Tenant = tenant;
            DisplayName = displayName;
            Parent = parent;
            State = state;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The AAD Tenant ID associated with the subscription. For example, 00000000-0000-0000-0000-000000000000. </summary>
        [WirePath("properties.tenant")]
        public string Tenant { get; }
        /// <summary> The friendly name of the subscription. </summary>
        [WirePath("properties.displayName")]
        public string DisplayName { get; }
        /// <summary> The ID of the parent management group. </summary>
        internal DescendantParentGroupInfo Parent { get; }
        /// <summary> The fully qualified ID for the parent management group.  For example, /providers/Microsoft.Management/managementGroups/0000000-0000-0000-0000-000000000000. </summary>
        [WirePath("properties.parent.id")]
        public ResourceIdentifier ParentId
        {
            get => Parent?.Id;
        }

        /// <summary> The state of the subscription. </summary>
        [WirePath("properties.state")]
        public string State { get; }
    }
}
