// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using Azure.Core;

namespace Azure.ResourceManager.Models
{
    /// <summary> The resource model definition representing SKU. </summary>
    [PropertyReferenceType]
    public partial class ArmSku
    {
        /// <summary> Initializes a new instance of <see cref="ArmSku"/>. </summary>
        /// <param name="name"> The name of the SKU. Ex - P3. It is typically a letter+number code. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/> is null. </exception>
        [InitializationConstructor]
        public ArmSku(string name)
        {
            Argument.AssertNotNull(name, nameof(name));

            Name = name;
        }

        /// <summary> Initializes a new instance of <see cref="ArmSku"/>. </summary>
        /// <param name="name"> The name of the SKU. Ex - P3. It is typically a letter+number code. </param>
        /// <param name="tier"> This field is required to be implemented by the Resource Provider if the service has more than one tier, but is not required on a PUT. </param>
        /// <param name="size"> The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code. </param>
        /// <param name="family"> If the service has different generations of hardware, for the same SKU, then that can be captured here. </param>
        /// <param name="capacity"> If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the resource this may be omitted. </param>
        [SerializationConstructor]
        internal ArmSku(string name, ArmSkuTier? tier, string size, string family, int? capacity)
        {
            Name = name;
            Tier = tier;
            Size = size;
            Family = family;
            Capacity = capacity;
        }

        /// <summary> Initializes a new instance of <see cref="ArmSku"/> for deserialization. </summary>
        internal ArmSku()
        {
        }

        /// <summary> The name of the SKU. Ex - P3. It is typically a letter+number code. </summary>
        [WirePath("name")]
        public string Name { get; set; }
        /// <summary> This field is required to be implemented by the Resource Provider if the service has more than one tier, but is not required on a PUT. </summary>
        [WirePath("tier")]
        public ArmSkuTier? Tier { get; set; }
        /// <summary> The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code. </summary>
        [WirePath("size")]
        public string Size { get; set; }
        /// <summary> If the service has different generations of hardware, for the same SKU, then that can be captured here. </summary>
        [WirePath("family")]
        public string Family { get; set; }
        /// <summary> If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the resource this may be omitted. </summary>
        [WirePath("capacity")]
        public int? Capacity { get; set; }
    }
}
