// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.Resources.Samples
{
    public partial class Sample_TenantPolicySetDefinitionResource
    {
        // Retrieve a built-in policy set definition
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_RetrieveABuiltInPolicySetDefinition()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Authorization/stable/2021-06-01/examples/getBuiltInPolicySetDefinition.json
            // this example is just showing the usage of "PolicySetDefinitions_GetBuiltIn" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this TenantPolicySetDefinitionResource created on azure
            // for more information of creating TenantPolicySetDefinitionResource, please refer to the document of TenantPolicySetDefinitionResource
            string policySetDefinitionName = "1f3afdf9-d0c9-4c3d-847f-89da613e70a8";
            ResourceIdentifier tenantPolicySetDefinitionResourceId = TenantPolicySetDefinitionResource.CreateResourceIdentifier(policySetDefinitionName);
            TenantPolicySetDefinitionResource tenantPolicySetDefinition = client.GetTenantPolicySetDefinitionResource(tenantPolicySetDefinitionResourceId);

            // invoke the operation
            TenantPolicySetDefinitionResource result = await tenantPolicySetDefinition.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            PolicySetDefinitionData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
