// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.Resources.Samples
{
    public partial class Sample_ResourceGroupResource
    {
        // Force delete all the Virtual Machines and Virtual Machine Scale Sets in a resource group
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_ForceDeleteAllTheVirtualMachinesAndVirtualMachineScaleSetsInAResourceGroup()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Resources/stable/2022-09-01/examples/ForceDeleteVMsAndVMSSInResourceGroup.json
            // this example is just showing the usage of "ResourceGroups_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "my-resource-group";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroup = client.GetResourceGroupResource(resourceGroupResourceId);

            // invoke the operation
            string forceDeletionTypes = "Microsoft.Compute/virtualMachines,Microsoft.Compute/virtualMachineScaleSets";
            await resourceGroup.DeleteAsync(WaitUntil.Completed, forceDeletionTypes: forceDeletionTypes);

            Console.WriteLine($"Succeeded");
        }

        // Force delete all the Virtual Machines in a resource group
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_ForceDeleteAllTheVirtualMachinesInAResourceGroup()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Resources/stable/2022-09-01/examples/ForceDeleteVMsInResourceGroup.json
            // this example is just showing the usage of "ResourceGroups_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "my-resource-group";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroup = client.GetResourceGroupResource(resourceGroupResourceId);

            // invoke the operation
            string forceDeletionTypes = "Microsoft.Compute/virtualMachines";
            await resourceGroup.DeleteAsync(WaitUntil.Completed, forceDeletionTypes: forceDeletionTypes);

            Console.WriteLine($"Succeeded");
        }

        // Export a resource group
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task ExportTemplate_ExportAResourceGroup()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Resources/stable/2022-09-01/examples/ExportResourceGroup.json
            // this example is just showing the usage of "ResourceGroups_ExportTemplate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "my-resource-group";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroup = client.GetResourceGroupResource(resourceGroupResourceId);

            // invoke the operation
            ExportTemplate exportTemplate = new ExportTemplate()
            {
                Resources =
{
"*"
},
                Options = "IncludeParameterDefaultValue,IncludeComments",
            };
            ArmOperation<ResourceGroupExportResult> lro = await resourceGroup.ExportTemplateAsync(WaitUntil.Completed, exportTemplate);
            ResourceGroupExportResult result = lro.Value;

            Console.WriteLine($"Succeeded: {result}");
        }

        // Export a resource group with filtering
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task ExportTemplate_ExportAResourceGroupWithFiltering()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Resources/stable/2022-09-01/examples/ExportResourceGroupWithFiltering.json
            // this example is just showing the usage of "ResourceGroups_ExportTemplate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "my-resource-group";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroup = client.GetResourceGroupResource(resourceGroupResourceId);

            // invoke the operation
            ExportTemplate exportTemplate = new ExportTemplate()
            {
                Resources =
{
"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/my-resource-group/providers/My.RP/myResourceType/myFirstResource"
},
                Options = "SkipResourceNameParameterization",
            };
            ArmOperation<ResourceGroupExportResult> lro = await resourceGroup.ExportTemplateAsync(WaitUntil.Completed, exportTemplate);
            ResourceGroupExportResult result = lro.Value;

            Console.WriteLine($"Succeeded: {result}");
        }
    }
}
