// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.Resources.Samples
{
    public partial class Sample_PolicyAssignmentResource
    {
        // Delete a policy assignment
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteAPolicyAssignment()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/deletePolicyAssignment.json
            // this example is just showing the usage of "PolicyAssignments_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PolicyAssignmentResource created on azure
            // for more information of creating PolicyAssignmentResource, please refer to the document of PolicyAssignmentResource
            string scope = "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2";
            string policyAssignmentName = "EnforceNaming";
            ResourceIdentifier policyAssignmentResourceId = PolicyAssignmentResource.CreateResourceIdentifier(scope, policyAssignmentName);
            PolicyAssignmentResource policyAssignment = client.GetPolicyAssignmentResource(policyAssignmentResourceId);

            // invoke the operation
            ArmOperation<PolicyAssignmentResource> lro = await policyAssignment.DeleteAsync(WaitUntil.Completed);
            PolicyAssignmentResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            PolicyAssignmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Retrieve a policy assignment
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_RetrieveAPolicyAssignment()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/getPolicyAssignment.json
            // this example is just showing the usage of "PolicyAssignments_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PolicyAssignmentResource created on azure
            // for more information of creating PolicyAssignmentResource, please refer to the document of PolicyAssignmentResource
            string scope = "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2";
            string policyAssignmentName = "EnforceNaming";
            ResourceIdentifier policyAssignmentResourceId = PolicyAssignmentResource.CreateResourceIdentifier(scope, policyAssignmentName);
            PolicyAssignmentResource policyAssignment = client.GetPolicyAssignmentResource(policyAssignmentResourceId);

            // invoke the operation
            PolicyAssignmentResource result = await policyAssignment.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            PolicyAssignmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Retrieve a policy assignment with a system assigned identity
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_RetrieveAPolicyAssignmentWithASystemAssignedIdentity()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/getPolicyAssignmentWithIdentity.json
            // this example is just showing the usage of "PolicyAssignments_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PolicyAssignmentResource created on azure
            // for more information of creating PolicyAssignmentResource, please refer to the document of PolicyAssignmentResource
            string scope = "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2";
            string policyAssignmentName = "EnforceNaming";
            ResourceIdentifier policyAssignmentResourceId = PolicyAssignmentResource.CreateResourceIdentifier(scope, policyAssignmentName);
            PolicyAssignmentResource policyAssignment = client.GetPolicyAssignmentResource(policyAssignmentResourceId);

            // invoke the operation
            PolicyAssignmentResource result = await policyAssignment.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            PolicyAssignmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Retrieve a policy assignment with a user assigned identity
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_RetrieveAPolicyAssignmentWithAUserAssignedIdentity()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/getPolicyAssignmentWithUserAssignedIdentity.json
            // this example is just showing the usage of "PolicyAssignments_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PolicyAssignmentResource created on azure
            // for more information of creating PolicyAssignmentResource, please refer to the document of PolicyAssignmentResource
            string scope = "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2";
            string policyAssignmentName = "EnforceNaming";
            ResourceIdentifier policyAssignmentResourceId = PolicyAssignmentResource.CreateResourceIdentifier(scope, policyAssignmentName);
            PolicyAssignmentResource policyAssignment = client.GetPolicyAssignmentResource(policyAssignmentResourceId);

            // invoke the operation
            PolicyAssignmentResource result = await policyAssignment.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            PolicyAssignmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Retrieve a policy assignment with overrides
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_RetrieveAPolicyAssignmentWithOverrides()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/getPolicyAssignmentWithOverrides.json
            // this example is just showing the usage of "PolicyAssignments_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PolicyAssignmentResource created on azure
            // for more information of creating PolicyAssignmentResource, please refer to the document of PolicyAssignmentResource
            string scope = "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2";
            string policyAssignmentName = "CostManagement";
            ResourceIdentifier policyAssignmentResourceId = PolicyAssignmentResource.CreateResourceIdentifier(scope, policyAssignmentName);
            PolicyAssignmentResource policyAssignment = client.GetPolicyAssignmentResource(policyAssignmentResourceId);

            // invoke the operation
            PolicyAssignmentResource result = await policyAssignment.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            PolicyAssignmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Retrieve a policy assignment with resource selectors
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_RetrieveAPolicyAssignmentWithResourceSelectors()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/getPolicyAssignmentWithResourceSelectors.json
            // this example is just showing the usage of "PolicyAssignments_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PolicyAssignmentResource created on azure
            // for more information of creating PolicyAssignmentResource, please refer to the document of PolicyAssignmentResource
            string scope = "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2";
            string policyAssignmentName = "CostManagement";
            ResourceIdentifier policyAssignmentResourceId = PolicyAssignmentResource.CreateResourceIdentifier(scope, policyAssignmentName);
            PolicyAssignmentResource policyAssignment = client.GetPolicyAssignmentResource(policyAssignmentResourceId);

            // invoke the operation
            PolicyAssignmentResource result = await policyAssignment.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            PolicyAssignmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Update a policy assignment with a system assigned identity
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateAPolicyAssignmentWithASystemAssignedIdentity()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/updatePolicyAssignmentWithIdentity.json
            // this example is just showing the usage of "PolicyAssignments_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PolicyAssignmentResource created on azure
            // for more information of creating PolicyAssignmentResource, please refer to the document of PolicyAssignmentResource
            string scope = "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2";
            string policyAssignmentName = "EnforceNaming";
            ResourceIdentifier policyAssignmentResourceId = PolicyAssignmentResource.CreateResourceIdentifier(scope, policyAssignmentName);
            PolicyAssignmentResource policyAssignment = client.GetPolicyAssignmentResource(policyAssignmentResourceId);

            // invoke the operation
            PolicyAssignmentPatch patch = new PolicyAssignmentPatch()
            {
                Location = new AzureLocation("eastus"),
                Identity = new ManagedServiceIdentity("SystemAssigned"),
            };
            PolicyAssignmentResource result = await policyAssignment.UpdateAsync(patch);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            PolicyAssignmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Update a policy assignment with a user assigned identity
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateAPolicyAssignmentWithAUserAssignedIdentity()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/updatePolicyAssignmentWithUserAssignedIdentity.json
            // this example is just showing the usage of "PolicyAssignments_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PolicyAssignmentResource created on azure
            // for more information of creating PolicyAssignmentResource, please refer to the document of PolicyAssignmentResource
            string scope = "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2";
            string policyAssignmentName = "EnforceNaming";
            ResourceIdentifier policyAssignmentResourceId = PolicyAssignmentResource.CreateResourceIdentifier(scope, policyAssignmentName);
            PolicyAssignmentResource policyAssignment = client.GetPolicyAssignmentResource(policyAssignmentResourceId);

            // invoke the operation
            PolicyAssignmentPatch patch = new PolicyAssignmentPatch()
            {
                Location = new AzureLocation("eastus"),
                Identity = new ManagedServiceIdentity("UserAssigned")
                {
                    UserAssignedIdentities =
{
[new ResourceIdentifier("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/resourceGroups/testResourceGroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/test-identity")] = new UserAssignedIdentity(),
},
                },
            };
            PolicyAssignmentResource result = await policyAssignment.UpdateAsync(patch);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            PolicyAssignmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Update a policy assignment with overrides
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateAPolicyAssignmentWithOverrides()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/updatePolicyAssignmentWithOverrides.json
            // this example is just showing the usage of "PolicyAssignments_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PolicyAssignmentResource created on azure
            // for more information of creating PolicyAssignmentResource, please refer to the document of PolicyAssignmentResource
            string scope = "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2";
            string policyAssignmentName = "CostManagement";
            ResourceIdentifier policyAssignmentResourceId = PolicyAssignmentResource.CreateResourceIdentifier(scope, policyAssignmentName);
            PolicyAssignmentResource policyAssignment = client.GetPolicyAssignmentResource(policyAssignmentResourceId);

            // invoke the operation
            PolicyAssignmentPatch patch = new PolicyAssignmentPatch()
            {
                Overrides =
{
new PolicyOverride()
{
Kind = PolicyOverrideKind.PolicyEffect,
Value = "Audit",
Selectors =
{
new ResourceSelectorExpression()
{
Kind = ResourceSelectorKind.PolicyDefinitionReferenceId,
In =
{
"Limit_Skus","Limit_Locations"
},
}
},
}
},
            };
            PolicyAssignmentResource result = await policyAssignment.UpdateAsync(patch);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            PolicyAssignmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Update a policy assignment with resource selectors
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateAPolicyAssignmentWithResourceSelectors()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/updatePolicyAssignmentWithResourceSelectors.json
            // this example is just showing the usage of "PolicyAssignments_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PolicyAssignmentResource created on azure
            // for more information of creating PolicyAssignmentResource, please refer to the document of PolicyAssignmentResource
            string scope = "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2";
            string policyAssignmentName = "CostManagement";
            ResourceIdentifier policyAssignmentResourceId = PolicyAssignmentResource.CreateResourceIdentifier(scope, policyAssignmentName);
            PolicyAssignmentResource policyAssignment = client.GetPolicyAssignmentResource(policyAssignmentResourceId);

            // invoke the operation
            PolicyAssignmentPatch patch = new PolicyAssignmentPatch()
            {
                ResourceSelectors =
{
new ResourceSelector()
{
Name = "SDPRegions",
Selectors =
{
new ResourceSelectorExpression()
{
Kind = ResourceSelectorKind.ResourceLocation,
In =
{
"eastus2euap","centraluseuap"
},
}
},
}
},
            };
            PolicyAssignmentResource result = await policyAssignment.UpdateAsync(patch);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            PolicyAssignmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
