// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.Resources.Samples
{
    public partial class Sample_PolicyAssignmentCollection
    {
        // Create or update a policy assignment
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateOrUpdateAPolicyAssignment()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/createPolicyAssignment.json
            // this example is just showing the usage of "PolicyAssignments_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmResource created on azure
            // for more information of creating ArmResource, please refer to the document of ArmResource

            // get the collection of this PolicyAssignmentResource
            string scope = "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2";
            ResourceIdentifier scopeId = new ResourceIdentifier(string.Format("/{0}", scope));
            PolicyAssignmentCollection collection = client.GetGenericResource(scopeId).GetPolicyAssignments();

            // invoke the operation
            string policyAssignmentName = "EnforceNaming";
            PolicyAssignmentData data = new PolicyAssignmentData()
            {
                DisplayName = "Enforce resource naming rules",
                PolicyDefinitionId = "/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming",
                Parameters =
{
["prefix"] = new ArmPolicyParameterValue()
{
Value = BinaryData.FromString("\"DeptA\""),
},
["suffix"] = new ArmPolicyParameterValue()
{
Value = BinaryData.FromString("\"-LC\""),
},
},
                Description = "Force resource names to begin with given DeptA and end with -LC",
                Metadata = BinaryData.FromObjectAsJson(new Dictionary<string, object>()
                {
                    ["assignedBy"] = "Special Someone"
                }),
                NonComplianceMessages =
{
new NonComplianceMessage("Resource names must start with 'DeptA' and end with '-LC'.")
},
            };
            ArmOperation<PolicyAssignmentResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, policyAssignmentName, data);
            PolicyAssignmentResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            PolicyAssignmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create or update a policy assignment with a system assigned identity
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateOrUpdateAPolicyAssignmentWithASystemAssignedIdentity()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/createPolicyAssignmentWithIdentity.json
            // this example is just showing the usage of "PolicyAssignments_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmResource created on azure
            // for more information of creating ArmResource, please refer to the document of ArmResource

            // get the collection of this PolicyAssignmentResource
            string scope = "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2";
            ResourceIdentifier scopeId = new ResourceIdentifier(string.Format("/{0}", scope));
            PolicyAssignmentCollection collection = client.GetGenericResource(scopeId).GetPolicyAssignments();

            // invoke the operation
            string policyAssignmentName = "EnforceNaming";
            PolicyAssignmentData data = new PolicyAssignmentData()
            {
                Location = new AzureLocation("eastus"),
                ManagedIdentity = new ManagedServiceIdentity("SystemAssigned"),
                DisplayName = "Enforce resource naming rules",
                PolicyDefinitionId = "/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming",
                Parameters =
{
["prefix"] = new ArmPolicyParameterValue()
{
Value = BinaryData.FromString("\"DeptA\""),
},
["suffix"] = new ArmPolicyParameterValue()
{
Value = BinaryData.FromString("\"-LC\""),
},
},
                Description = "Force resource names to begin with given DeptA and end with -LC",
                Metadata = BinaryData.FromObjectAsJson(new Dictionary<string, object>()
                {
                    ["assignedBy"] = "Foo Bar"
                }),
                EnforcementMode = EnforcementMode.Default,
            };
            ArmOperation<PolicyAssignmentResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, policyAssignmentName, data);
            PolicyAssignmentResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            PolicyAssignmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create or update a policy assignment with a user assigned identity
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateOrUpdateAPolicyAssignmentWithAUserAssignedIdentity()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/createPolicyAssignmentWithUserAssignedIdentity.json
            // this example is just showing the usage of "PolicyAssignments_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmResource created on azure
            // for more information of creating ArmResource, please refer to the document of ArmResource

            // get the collection of this PolicyAssignmentResource
            string scope = "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2";
            ResourceIdentifier scopeId = new ResourceIdentifier(string.Format("/{0}", scope));
            PolicyAssignmentCollection collection = client.GetGenericResource(scopeId).GetPolicyAssignments();

            // invoke the operation
            string policyAssignmentName = "EnforceNaming";
            PolicyAssignmentData data = new PolicyAssignmentData()
            {
                Location = new AzureLocation("eastus"),
                ManagedIdentity = new ManagedServiceIdentity("UserAssigned")
                {
                    UserAssignedIdentities =
{
[new ResourceIdentifier("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/resourceGroups/testResourceGroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/test-identity")] = new UserAssignedIdentity(),
},
                },
                DisplayName = "Enforce resource naming rules",
                PolicyDefinitionId = "/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming",
                Parameters =
{
["prefix"] = new ArmPolicyParameterValue()
{
Value = BinaryData.FromString("\"DeptA\""),
},
["suffix"] = new ArmPolicyParameterValue()
{
Value = BinaryData.FromString("\"-LC\""),
},
},
                Description = "Force resource names to begin with given DeptA and end with -LC",
                Metadata = BinaryData.FromObjectAsJson(new Dictionary<string, object>()
                {
                    ["assignedBy"] = "Foo Bar"
                }),
                EnforcementMode = EnforcementMode.Default,
            };
            ArmOperation<PolicyAssignmentResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, policyAssignmentName, data);
            PolicyAssignmentResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            PolicyAssignmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create or update a policy assignment with multiple non-compliance messages
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateOrUpdateAPolicyAssignmentWithMultipleNonComplianceMessages()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/createPolicyAssignmentNonComplianceMessages.json
            // this example is just showing the usage of "PolicyAssignments_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmResource created on azure
            // for more information of creating ArmResource, please refer to the document of ArmResource

            // get the collection of this PolicyAssignmentResource
            string scope = "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2";
            ResourceIdentifier scopeId = new ResourceIdentifier(string.Format("/{0}", scope));
            PolicyAssignmentCollection collection = client.GetGenericResource(scopeId).GetPolicyAssignments();

            // invoke the operation
            string policyAssignmentName = "securityInitAssignment";
            PolicyAssignmentData data = new PolicyAssignmentData()
            {
                DisplayName = "Enforce security policies",
                PolicyDefinitionId = "/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policySetDefinitions/securityInitiative",
                NonComplianceMessages =
{
new NonComplianceMessage("Resources must comply with all internal security policies. See <internal site URL> for more info."),new NonComplianceMessage("Resource names must start with 'DeptA' and end with '-LC'.")
{
PolicyDefinitionReferenceId = "10420126870854049575",
},new NonComplianceMessage("Storage accounts must have firewall rules configured.")
{
PolicyDefinitionReferenceId = "8572513655450389710",
}
},
            };
            ArmOperation<PolicyAssignmentResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, policyAssignmentName, data);
            PolicyAssignmentResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            PolicyAssignmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create or update a policy assignment with overrides
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateOrUpdateAPolicyAssignmentWithOverrides()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/createPolicyAssignmentWithOverrides.json
            // this example is just showing the usage of "PolicyAssignments_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmResource created on azure
            // for more information of creating ArmResource, please refer to the document of ArmResource

            // get the collection of this PolicyAssignmentResource
            string scope = "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2";
            ResourceIdentifier scopeId = new ResourceIdentifier(string.Format("/{0}", scope));
            PolicyAssignmentCollection collection = client.GetGenericResource(scopeId).GetPolicyAssignments();

            // invoke the operation
            string policyAssignmentName = "CostManagement";
            PolicyAssignmentData data = new PolicyAssignmentData()
            {
                DisplayName = "Limit the resource location and resource SKU",
                PolicyDefinitionId = "/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policySetDefinitions/CostManagement",
                Description = "Limit the resource location and resource SKU",
                Metadata = BinaryData.FromObjectAsJson(new Dictionary<string, object>()
                {
                    ["assignedBy"] = "Special Someone"
                }),
                Overrides =
{
new PolicyOverride()
{
Kind = PolicyOverrideKind.PolicyEffect,
Value = "Audit",
Selectors =
{
new ResourceSelectorExpression()
{
Kind = ResourceSelectorKind.PolicyDefinitionReferenceId,
In =
{
"Limit_Skus","Limit_Locations"
},
}
},
}
},
            };
            ArmOperation<PolicyAssignmentResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, policyAssignmentName, data);
            PolicyAssignmentResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            PolicyAssignmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create or update a policy assignment with resource selectors
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateOrUpdateAPolicyAssignmentWithResourceSelectors()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/createPolicyAssignmentWithResourceSelectors.json
            // this example is just showing the usage of "PolicyAssignments_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmResource created on azure
            // for more information of creating ArmResource, please refer to the document of ArmResource

            // get the collection of this PolicyAssignmentResource
            string scope = "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2";
            ResourceIdentifier scopeId = new ResourceIdentifier(string.Format("/{0}", scope));
            PolicyAssignmentCollection collection = client.GetGenericResource(scopeId).GetPolicyAssignments();

            // invoke the operation
            string policyAssignmentName = "CostManagement";
            PolicyAssignmentData data = new PolicyAssignmentData()
            {
                DisplayName = "Limit the resource location and resource SKU",
                PolicyDefinitionId = "/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policySetDefinitions/CostManagement",
                Description = "Limit the resource location and resource SKU",
                Metadata = BinaryData.FromObjectAsJson(new Dictionary<string, object>()
                {
                    ["assignedBy"] = "Special Someone"
                }),
                ResourceSelectors =
{
new ResourceSelector()
{
Name = "SDPRegions",
Selectors =
{
new ResourceSelectorExpression()
{
Kind = ResourceSelectorKind.ResourceLocation,
In =
{
"eastus2euap","centraluseuap"
},
}
},
}
},
            };
            ArmOperation<PolicyAssignmentResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, policyAssignmentName, data);
            PolicyAssignmentResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            PolicyAssignmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create or update a policy assignment without enforcing policy effect during resource creation or update.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateOrUpdateAPolicyAssignmentWithoutEnforcingPolicyEffectDuringResourceCreationOrUpdate()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/createPolicyAssignmentWithoutEnforcement.json
            // this example is just showing the usage of "PolicyAssignments_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmResource created on azure
            // for more information of creating ArmResource, please refer to the document of ArmResource

            // get the collection of this PolicyAssignmentResource
            string scope = "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2";
            ResourceIdentifier scopeId = new ResourceIdentifier(string.Format("/{0}", scope));
            PolicyAssignmentCollection collection = client.GetGenericResource(scopeId).GetPolicyAssignments();

            // invoke the operation
            string policyAssignmentName = "EnforceNaming";
            PolicyAssignmentData data = new PolicyAssignmentData()
            {
                DisplayName = "Enforce resource naming rules",
                PolicyDefinitionId = "/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming",
                Parameters =
{
["prefix"] = new ArmPolicyParameterValue()
{
Value = BinaryData.FromString("\"DeptA\""),
},
["suffix"] = new ArmPolicyParameterValue()
{
Value = BinaryData.FromString("\"-LC\""),
},
},
                Description = "Force resource names to begin with given DeptA and end with -LC",
                Metadata = BinaryData.FromObjectAsJson(new Dictionary<string, object>()
                {
                    ["assignedBy"] = "Special Someone"
                }),
                EnforcementMode = EnforcementMode.DoNotEnforce,
            };
            ArmOperation<PolicyAssignmentResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, policyAssignmentName, data);
            PolicyAssignmentResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            PolicyAssignmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Retrieve a policy assignment
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_RetrieveAPolicyAssignment()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/getPolicyAssignment.json
            // this example is just showing the usage of "PolicyAssignments_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmResource created on azure
            // for more information of creating ArmResource, please refer to the document of ArmResource

            // get the collection of this PolicyAssignmentResource
            string scope = "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2";
            ResourceIdentifier scopeId = new ResourceIdentifier(string.Format("/{0}", scope));
            PolicyAssignmentCollection collection = client.GetGenericResource(scopeId).GetPolicyAssignments();

            // invoke the operation
            string policyAssignmentName = "EnforceNaming";
            PolicyAssignmentResource result = await collection.GetAsync(policyAssignmentName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            PolicyAssignmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Retrieve a policy assignment
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_RetrieveAPolicyAssignment()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/getPolicyAssignment.json
            // this example is just showing the usage of "PolicyAssignments_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmResource created on azure
            // for more information of creating ArmResource, please refer to the document of ArmResource

            // get the collection of this PolicyAssignmentResource
            string scope = "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2";
            ResourceIdentifier scopeId = new ResourceIdentifier(string.Format("/{0}", scope));
            PolicyAssignmentCollection collection = client.GetGenericResource(scopeId).GetPolicyAssignments();

            // invoke the operation
            string policyAssignmentName = "EnforceNaming";
            bool result = await collection.ExistsAsync(policyAssignmentName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Retrieve a policy assignment
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_RetrieveAPolicyAssignment()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/getPolicyAssignment.json
            // this example is just showing the usage of "PolicyAssignments_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmResource created on azure
            // for more information of creating ArmResource, please refer to the document of ArmResource

            // get the collection of this PolicyAssignmentResource
            string scope = "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2";
            ResourceIdentifier scopeId = new ResourceIdentifier(string.Format("/{0}", scope));
            PolicyAssignmentCollection collection = client.GetGenericResource(scopeId).GetPolicyAssignments();

            // invoke the operation
            string policyAssignmentName = "EnforceNaming";
            NullableResponse<PolicyAssignmentResource> response = await collection.GetIfExistsAsync(policyAssignmentName);
            PolicyAssignmentResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                PolicyAssignmentData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Retrieve a policy assignment with a system assigned identity
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_RetrieveAPolicyAssignmentWithASystemAssignedIdentity()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/getPolicyAssignmentWithIdentity.json
            // this example is just showing the usage of "PolicyAssignments_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmResource created on azure
            // for more information of creating ArmResource, please refer to the document of ArmResource

            // get the collection of this PolicyAssignmentResource
            string scope = "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2";
            ResourceIdentifier scopeId = new ResourceIdentifier(string.Format("/{0}", scope));
            PolicyAssignmentCollection collection = client.GetGenericResource(scopeId).GetPolicyAssignments();

            // invoke the operation
            string policyAssignmentName = "EnforceNaming";
            PolicyAssignmentResource result = await collection.GetAsync(policyAssignmentName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            PolicyAssignmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Retrieve a policy assignment with a system assigned identity
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_RetrieveAPolicyAssignmentWithASystemAssignedIdentity()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/getPolicyAssignmentWithIdentity.json
            // this example is just showing the usage of "PolicyAssignments_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmResource created on azure
            // for more information of creating ArmResource, please refer to the document of ArmResource

            // get the collection of this PolicyAssignmentResource
            string scope = "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2";
            ResourceIdentifier scopeId = new ResourceIdentifier(string.Format("/{0}", scope));
            PolicyAssignmentCollection collection = client.GetGenericResource(scopeId).GetPolicyAssignments();

            // invoke the operation
            string policyAssignmentName = "EnforceNaming";
            bool result = await collection.ExistsAsync(policyAssignmentName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Retrieve a policy assignment with a system assigned identity
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_RetrieveAPolicyAssignmentWithASystemAssignedIdentity()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/getPolicyAssignmentWithIdentity.json
            // this example is just showing the usage of "PolicyAssignments_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmResource created on azure
            // for more information of creating ArmResource, please refer to the document of ArmResource

            // get the collection of this PolicyAssignmentResource
            string scope = "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2";
            ResourceIdentifier scopeId = new ResourceIdentifier(string.Format("/{0}", scope));
            PolicyAssignmentCollection collection = client.GetGenericResource(scopeId).GetPolicyAssignments();

            // invoke the operation
            string policyAssignmentName = "EnforceNaming";
            NullableResponse<PolicyAssignmentResource> response = await collection.GetIfExistsAsync(policyAssignmentName);
            PolicyAssignmentResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                PolicyAssignmentData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Retrieve a policy assignment with a user assigned identity
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_RetrieveAPolicyAssignmentWithAUserAssignedIdentity()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/getPolicyAssignmentWithUserAssignedIdentity.json
            // this example is just showing the usage of "PolicyAssignments_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmResource created on azure
            // for more information of creating ArmResource, please refer to the document of ArmResource

            // get the collection of this PolicyAssignmentResource
            string scope = "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2";
            ResourceIdentifier scopeId = new ResourceIdentifier(string.Format("/{0}", scope));
            PolicyAssignmentCollection collection = client.GetGenericResource(scopeId).GetPolicyAssignments();

            // invoke the operation
            string policyAssignmentName = "EnforceNaming";
            PolicyAssignmentResource result = await collection.GetAsync(policyAssignmentName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            PolicyAssignmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Retrieve a policy assignment with a user assigned identity
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_RetrieveAPolicyAssignmentWithAUserAssignedIdentity()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/getPolicyAssignmentWithUserAssignedIdentity.json
            // this example is just showing the usage of "PolicyAssignments_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmResource created on azure
            // for more information of creating ArmResource, please refer to the document of ArmResource

            // get the collection of this PolicyAssignmentResource
            string scope = "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2";
            ResourceIdentifier scopeId = new ResourceIdentifier(string.Format("/{0}", scope));
            PolicyAssignmentCollection collection = client.GetGenericResource(scopeId).GetPolicyAssignments();

            // invoke the operation
            string policyAssignmentName = "EnforceNaming";
            bool result = await collection.ExistsAsync(policyAssignmentName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Retrieve a policy assignment with a user assigned identity
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_RetrieveAPolicyAssignmentWithAUserAssignedIdentity()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/getPolicyAssignmentWithUserAssignedIdentity.json
            // this example is just showing the usage of "PolicyAssignments_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmResource created on azure
            // for more information of creating ArmResource, please refer to the document of ArmResource

            // get the collection of this PolicyAssignmentResource
            string scope = "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2";
            ResourceIdentifier scopeId = new ResourceIdentifier(string.Format("/{0}", scope));
            PolicyAssignmentCollection collection = client.GetGenericResource(scopeId).GetPolicyAssignments();

            // invoke the operation
            string policyAssignmentName = "EnforceNaming";
            NullableResponse<PolicyAssignmentResource> response = await collection.GetIfExistsAsync(policyAssignmentName);
            PolicyAssignmentResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                PolicyAssignmentData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Retrieve a policy assignment with overrides
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_RetrieveAPolicyAssignmentWithOverrides()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/getPolicyAssignmentWithOverrides.json
            // this example is just showing the usage of "PolicyAssignments_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmResource created on azure
            // for more information of creating ArmResource, please refer to the document of ArmResource

            // get the collection of this PolicyAssignmentResource
            string scope = "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2";
            ResourceIdentifier scopeId = new ResourceIdentifier(string.Format("/{0}", scope));
            PolicyAssignmentCollection collection = client.GetGenericResource(scopeId).GetPolicyAssignments();

            // invoke the operation
            string policyAssignmentName = "CostManagement";
            PolicyAssignmentResource result = await collection.GetAsync(policyAssignmentName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            PolicyAssignmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Retrieve a policy assignment with overrides
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_RetrieveAPolicyAssignmentWithOverrides()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/getPolicyAssignmentWithOverrides.json
            // this example is just showing the usage of "PolicyAssignments_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmResource created on azure
            // for more information of creating ArmResource, please refer to the document of ArmResource

            // get the collection of this PolicyAssignmentResource
            string scope = "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2";
            ResourceIdentifier scopeId = new ResourceIdentifier(string.Format("/{0}", scope));
            PolicyAssignmentCollection collection = client.GetGenericResource(scopeId).GetPolicyAssignments();

            // invoke the operation
            string policyAssignmentName = "CostManagement";
            bool result = await collection.ExistsAsync(policyAssignmentName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Retrieve a policy assignment with overrides
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_RetrieveAPolicyAssignmentWithOverrides()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/getPolicyAssignmentWithOverrides.json
            // this example is just showing the usage of "PolicyAssignments_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmResource created on azure
            // for more information of creating ArmResource, please refer to the document of ArmResource

            // get the collection of this PolicyAssignmentResource
            string scope = "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2";
            ResourceIdentifier scopeId = new ResourceIdentifier(string.Format("/{0}", scope));
            PolicyAssignmentCollection collection = client.GetGenericResource(scopeId).GetPolicyAssignments();

            // invoke the operation
            string policyAssignmentName = "CostManagement";
            NullableResponse<PolicyAssignmentResource> response = await collection.GetIfExistsAsync(policyAssignmentName);
            PolicyAssignmentResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                PolicyAssignmentData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Retrieve a policy assignment with resource selectors
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_RetrieveAPolicyAssignmentWithResourceSelectors()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/getPolicyAssignmentWithResourceSelectors.json
            // this example is just showing the usage of "PolicyAssignments_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmResource created on azure
            // for more information of creating ArmResource, please refer to the document of ArmResource

            // get the collection of this PolicyAssignmentResource
            string scope = "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2";
            ResourceIdentifier scopeId = new ResourceIdentifier(string.Format("/{0}", scope));
            PolicyAssignmentCollection collection = client.GetGenericResource(scopeId).GetPolicyAssignments();

            // invoke the operation
            string policyAssignmentName = "CostManagement";
            PolicyAssignmentResource result = await collection.GetAsync(policyAssignmentName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            PolicyAssignmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Retrieve a policy assignment with resource selectors
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_RetrieveAPolicyAssignmentWithResourceSelectors()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/getPolicyAssignmentWithResourceSelectors.json
            // this example is just showing the usage of "PolicyAssignments_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmResource created on azure
            // for more information of creating ArmResource, please refer to the document of ArmResource

            // get the collection of this PolicyAssignmentResource
            string scope = "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2";
            ResourceIdentifier scopeId = new ResourceIdentifier(string.Format("/{0}", scope));
            PolicyAssignmentCollection collection = client.GetGenericResource(scopeId).GetPolicyAssignments();

            // invoke the operation
            string policyAssignmentName = "CostManagement";
            bool result = await collection.ExistsAsync(policyAssignmentName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Retrieve a policy assignment with resource selectors
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_RetrieveAPolicyAssignmentWithResourceSelectors()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/getPolicyAssignmentWithResourceSelectors.json
            // this example is just showing the usage of "PolicyAssignments_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmResource created on azure
            // for more information of creating ArmResource, please refer to the document of ArmResource

            // get the collection of this PolicyAssignmentResource
            string scope = "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2";
            ResourceIdentifier scopeId = new ResourceIdentifier(string.Format("/{0}", scope));
            PolicyAssignmentCollection collection = client.GetGenericResource(scopeId).GetPolicyAssignments();

            // invoke the operation
            string policyAssignmentName = "CostManagement";
            NullableResponse<PolicyAssignmentResource> response = await collection.GetIfExistsAsync(policyAssignmentName);
            PolicyAssignmentResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                PolicyAssignmentData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // List policy assignments that apply to a resource group
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_ListPolicyAssignmentsThatApplyToAResourceGroup()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/listPolicyAssignmentsForResourceGroup.json
            // this example is just showing the usage of "PolicyAssignments_ListForResourceGroup" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmResource created on azure
            // for more information of creating ArmResource, please refer to the document of ArmResource

            // get the collection of this PolicyAssignmentResource
            string subscriptionId = "ae640e6b-ba3e-4256-9d62-2993eecfa6f2";
            string resourceGroupName = "TestResourceGroup";
            ResourceIdentifier scopeId = new ResourceIdentifier(string.Format("/subscriptions/{0}/resourceGroups/{1}", subscriptionId, resourceGroupName));
            PolicyAssignmentCollection collection = client.GetGenericResource(scopeId).GetPolicyAssignments();

            // invoke the operation and iterate over the result
            string filter = "atScope()";
            await foreach (PolicyAssignmentResource item in collection.GetAllAsync(filter: filter))
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                PolicyAssignmentData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // List all policy assignments that apply to a resource
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_ListAllPolicyAssignmentsThatApplyToAResource()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/listPolicyAssignmentsForResource.json
            // this example is just showing the usage of "PolicyAssignments_ListForResource" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmResource created on azure
            // for more information of creating ArmResource, please refer to the document of ArmResource

            // get the collection of this PolicyAssignmentResource
            string subscriptionId = "ae640e6b-ba3e-4256-9d62-2993eecfa6f2";
            string resourceGroupName = "TestResourceGroup";
            string resourceProviderNamespace = "Microsoft.Compute";
            string parentResourcePath = "virtualMachines/MyTestVm";
            string resourceType = "domainNames";
            string resourceName = "MyTestComputer.cloudapp.net";
            ResourceIdentifier scopeId = new ResourceIdentifier(string.Format("/subscriptions/{0}/resourceGroups/{1}/providers/{2}/{3}/{4}/{5}", subscriptionId, resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName));
            PolicyAssignmentCollection collection = client.GetGenericResource(scopeId).GetPolicyAssignments();

            // invoke the operation and iterate over the result
            await foreach (PolicyAssignmentResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                PolicyAssignmentData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // List policy assignments that apply to a management group
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_ListPolicyAssignmentsThatApplyToAManagementGroup()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/listPolicyAssignmentsForManagementGroup.json
            // this example is just showing the usage of "PolicyAssignments_ListForManagementGroup" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmResource created on azure
            // for more information of creating ArmResource, please refer to the document of ArmResource

            // get the collection of this PolicyAssignmentResource
            string managementGroupId = "TestManagementGroup";
            ResourceIdentifier scopeId = new ResourceIdentifier(string.Format("/providers/Microsoft.Management/managementGroups/{0}", managementGroupId));
            PolicyAssignmentCollection collection = client.GetGenericResource(scopeId).GetPolicyAssignments();

            // invoke the operation and iterate over the result
            string filter = "atScope()";
            await foreach (PolicyAssignmentResource item in collection.GetAllAsync(filter: filter))
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                PolicyAssignmentData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // List policy assignments that apply to a subscription
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_ListPolicyAssignmentsThatApplyToASubscription()
        {
            // Generated from example definition: specification/resources/resource-manager/Microsoft.Authorization/stable/2022-06-01/examples/listPolicyAssignments.json
            // this example is just showing the usage of "PolicyAssignments_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmResource created on azure
            // for more information of creating ArmResource, please refer to the document of ArmResource

            // get the collection of this PolicyAssignmentResource
            string subscriptionId = "ae640e6b-ba3e-4256-9d62-2993eecfa6f2";
            ResourceIdentifier scopeId = new ResourceIdentifier(string.Format("/subscriptions/{0}", subscriptionId));
            PolicyAssignmentCollection collection = client.GetGenericResource(scopeId).GetPolicyAssignments();

            // invoke the operation and iterate over the result
            string filter = "atScope()";
            await foreach (PolicyAssignmentResource item in collection.GetAllAsync(filter: filter))
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                PolicyAssignmentData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
